"use strict";
var __importDefault = (this && this.__importDefault) || function (mod) {
    return (mod && mod.__esModule) ? mod : { "default": mod };
};
Object.defineProperty(exports, "__esModule", { value: true });
const express_1 = __importDefault(require("express"));
const mongoose_1 = __importDefault(require("mongoose"));
const helmet_1 = __importDefault(require("helmet"));
const cors_1 = __importDefault(require("cors"));
const path_1 = __importDefault(require("path"));
require('dotenv').config();
const admin_routes_1 = __importDefault(require("./routes/admin-routes"));
const outsourced_routes_1 = __importDefault(require("./routes/outsourced-routes"));
const general_routes_1 = __importDefault(require("./routes/general-routes"));
const technicians_routes_1 = __importDefault(require("./routes/technicians-routes"));
const app = (0, express_1.default)();
const port = process.env.PORT || 3000;
const corsOptions = {
    origin: '*', // Replace '*' with your domain for security, e.g., 'https://yourdomain.com'
    methods: 'GET,HEAD,PUT,PATCH,POST,DELETE',
    preflightContinue: false,
    optionsSuccessStatus: 204,
    exposedHeaders: ['Content-Length', 'X-Requested-With', 'Content-Type', 'Accept', 'Authorization', 'Origin', 'User-Token'],
};
app.use((0, cors_1.default)(corsOptions));
app.use((0, helmet_1.default)({
    crossOriginResourcePolicy: false,
    crossOriginEmbedderPolicy: false,
    contentSecurityPolicy: {
        directives: {
            defaultSrc: ['*'],
            scriptSrc: ["* data: 'unsafe-eval' 'unsafe-inline' blob:"]
        }
    }
}));
app.use(express_1.default.json({ limit: '50mb' }));
app.use(express_1.default.urlencoded({ extended: true, parameterLimit: 50000, limit: '50mb' }));
app.use('/public', express_1.default.static(path_1.default.join(__dirname, 'public')));
mongoose_1.default.Promise = global.Promise;
mongoose_1.default
    .connect(process.env.MONGODB_URI)
    .then((x) => {
    console.log(`Connected to Mongo! Database name: "${x.connections[0].name}"`);
})
    .catch((err) => {
    console.error('Could not connect to the database', err);
});
app.get('/', (req, res) => {
    res.json({ message: "Minutes landing page" });
});
app.use('/admin', admin_routes_1.default);
app.use('/technician', technicians_routes_1.default);
app.use('/outsourced', outsourced_routes_1.default);
app.use('/general', general_routes_1.default);
app.use((err, req, res, next) => {
    if (err instanceof SyntaxError && 'body' in err) {
        return res.status(400).json({
            status: 'error',
            message: 'Invalid JSON payload',
            error: err.message,
        });
    }
    next(err);
});
app.listen(port, () => {
    console.log("Server is listening on port " + port);
});
