"use strict";
var __createBinding = (this && this.__createBinding) || (Object.create ? (function(o, m, k, k2) {
    if (k2 === undefined) k2 = k;
    var desc = Object.getOwnPropertyDescriptor(m, k);
    if (!desc || ("get" in desc ? !m.__esModule : desc.writable || desc.configurable)) {
      desc = { enumerable: true, get: function() { return m[k]; } };
    }
    Object.defineProperty(o, k2, desc);
}) : (function(o, m, k, k2) {
    if (k2 === undefined) k2 = k;
    o[k2] = m[k];
}));
var __setModuleDefault = (this && this.__setModuleDefault) || (Object.create ? (function(o, v) {
    Object.defineProperty(o, "default", { enumerable: true, value: v });
}) : function(o, v) {
    o["default"] = v;
});
var __importStar = (this && this.__importStar) || function (mod) {
    if (mod && mod.__esModule) return mod;
    var result = {};
    if (mod != null) for (var k in mod) if (k !== "default" && Object.prototype.hasOwnProperty.call(mod, k)) __createBinding(result, mod, k);
    __setModuleDefault(result, mod);
    return result;
};
var __importDefault = (this && this.__importDefault) || function (mod) {
    return (mod && mod.__esModule) ? mod : { "default": mod };
};
Object.defineProperty(exports, "__esModule", { value: true });
const jsonwebtoken_1 = __importStar(require("jsonwebtoken"));
const admin_user_model_1 = __importDefault(require("../../src/model/admin/staff-management/admin-user-model"));
const lodash_1 = require("lodash");
const authMiddleware = async (req, res, next) => {
    try {
        const token = req.header('Authorization')?.split(' ')[1];
        if (token) {
            let user = null;
            let checkToken = null;
            if (token === process.env.APP_AUTH_KEY) {
                user = await admin_user_model_1.default.findOne({ userTitle: "Sap" }).populate('designationId', ['designationTitle', 'slug']);
            }
            else {
                checkToken = jsonwebtoken_1.default.verify(token, `${process.env.TOKEN_SECRET_KEY}`);
                if (!checkToken) {
                    return res.status(201).json({ message: 'Unauthorized - Invalid token', status: false, reLogin: true });
                }
                user = await admin_user_model_1.default.findOne({ _id: checkToken.userId });
            }
            if (!user) {
                return res.status(201).json({ message: 'User not found. Unauthorized - Invalid token', status: false, reLogin: true });
            }
            const userData = {
                _id: user?._id,
                designationId: checkToken?.designationId?.slug ? checkToken.designationId : user.designationId,
                userTitle: user?.userTitle,
                branchId: user?.branchId,
                departmentId: user?.departmentId,
                countryId: user?.countryId,
                stateId: user?.stateId,
                cityId: user?.cityId,
                userCode: user?.userCode,
                userEmail: user?.userEmail,
                userPhoneNumber: user?.userPhoneNumber,
                status: user?.status,
                ...(!(0, lodash_1.isEmpty)(checkToken?.branchDetails) ? { branchDetails: checkToken.branchDetails } : {})
            };
            // console.log(checkToken);
            if (userData) {
                req.user = userData;
                res.locals.user = userData;
                next();
            }
            else {
                return res.status(201).json({ message: 'Invalid user name or password!', status: false, reLogin: false });
            }
        }
        else {
            return res.status(201).json({ message: 'Unauthorized - Missing token', status: false, reLogin: true });
        }
    }
    catch (error) {
        if (error instanceof jsonwebtoken_1.TokenExpiredError) {
            return res.status(201).json({ message: 'Unauthorized - Token expired', status: false, reLogin: true });
        }
        else {
            console.error(error);
            return res.status(500).json({ message: JSON.stringify(error), status: false, reLogin: true });
        }
    }
};
exports.default = authMiddleware;
