"use strict";
var __importDefault = (this && this.__importDefault) || function (mod) {
    return (mod && mod.__esModule) ? mod : { "default": mod };
};
Object.defineProperty(exports, "__esModule", { value: true });
const express_1 = __importDefault(require("express"));
//admin
const auth_routes_1 = __importDefault(require("./admin/auth-routes"));
const auth_middleware_1 = __importDefault(require("../middleware/admin/auth-middleware"));
const dashboard_routes_1 = __importDefault(require("./admin/dashboard-routes"));
// job-orders
const job_order_routes_1 = __importDefault(require("./admin/job-order/job-order-routes"));
// other 
const payment_cost_routes_1 = __importDefault(require("./admin/other/payment-cost-routes"));
const condition_routes_1 = __importDefault(require("./admin/other/condition-routes"));
const additional_cost_values_routes_1 = __importDefault(require("./admin/other/additional-cost-values-routes"));
const service_status_routes_1 = __importDefault(require("./admin/other/service-status-routes"));
const customer_accessory_routes_1 = __importDefault(require("./admin/other/customer-accessory.routes"));
// inventory-management
const products_routes_1 = __importDefault(require("./admin/inventory-management/products/products.routes"));
const item_master_routes_1 = __importDefault(require("./admin/inventory-management/items/item-master-routes"));
const item_details_routes_1 = __importDefault(require("./admin/inventory-management/items/item-details-routes"));
const attributes_routes_1 = __importDefault(require("./admin/inventory-management/attributes-routes"));
const category_routes_1 = __importDefault(require("./admin/inventory-management/category-routes"));
const warranty_routes_1 = __importDefault(require("./admin/inventory-management/warranty-routes"));
const complaint_routes_1 = __importDefault(require("./admin/inventory-management/complaint-routes"));
// admin staff-management
const admin_user_routes_1 = __importDefault(require("./admin/staff-management/admin-user-routes"));
const designation_routes_1 = __importDefault(require("./admin/staff-management/designation-routes"));
const department_routes_1 = __importDefault(require("./admin/staff-management/department-routes"));
const privilage_routes_1 = __importDefault(require("./admin/staff-management/privilage-routes"));
// customer-management
const customer_routes_1 = __importDefault(require("./admin/customer-management/customer-routes"));
const referral_source_routes_1 = __importDefault(require("./admin/customer-management/referral-source.routes"));
// operation
const branch_routes_1 = __importDefault(require("./admin/operations/branch-routes"));
const warehouse_routes_1 = __importDefault(require("./admin/operations/warehouse-routes"));
// settings
const setttings_router_1 = __importDefault(require("./admin/settings/setttings.router"));
const customer_other_service_detail_router_1 = __importDefault(require("./admin/other/customer-other-service-detail.router"));
const adminRouter = express_1.default.Router();
// admin
adminRouter.use('/auth', auth_routes_1.default);
// adminRouter.use(authMiddleware); // Apply authMiddleware only to the following routes
adminRouter.use(auth_middleware_1.default);
// dashboard
adminRouter.use('/dashboard', dashboard_routes_1.default);
// job-orders
adminRouter.use('/job-order', job_order_routes_1.default);
// inventory-management
adminRouter.use('/inventory-management/items/item-master', item_master_routes_1.default);
adminRouter.use('/inventory-management/items/item-details', item_details_routes_1.default);
adminRouter.use('/inventory-management/attribute', attributes_routes_1.default);
adminRouter.use('/inventory-management/category', category_routes_1.default);
adminRouter.use('/inventory-management/warranty', warranty_routes_1.default);
adminRouter.use('/inventory-management/complaint', complaint_routes_1.default);
// inventory-management
adminRouter.use('/inventory-management/products', products_routes_1.default);
// staff-management
adminRouter.use('/staff-management/admin-users', admin_user_routes_1.default);
adminRouter.use('/staff-management/designation', designation_routes_1.default);
adminRouter.use('/staff-management/department', department_routes_1.default);
adminRouter.use('/staff-management/admin-user-privilages', privilage_routes_1.default);
// customer-management
adminRouter.use('/customer-management/customer', customer_routes_1.default);
adminRouter.use('/customer-management/referral-source', referral_source_routes_1.default);
// outsourced
// operations 
adminRouter.use('/operation/branch', branch_routes_1.default);
adminRouter.use('/operation/warehouse', warehouse_routes_1.default);
// other 
adminRouter.use('/other/payment-term-cost-center', payment_cost_routes_1.default);
adminRouter.use('/other/conditions', condition_routes_1.default);
adminRouter.use('/other/customer-other-service-detail', customer_other_service_detail_router_1.default);
adminRouter.use('/other/customer-accessories', customer_accessory_routes_1.default);
adminRouter.use('/other/additional-cost-values', additional_cost_values_routes_1.default);
adminRouter.use('/other/service-status', service_status_routes_1.default);
// settings
adminRouter.use('/settings', setttings_router_1.default);
exports.default = adminRouter;
