"use strict";
var __importDefault = (this && this.__importDefault) || function (mod) {
    return (mod && mod.__esModule) ? mod : { "default": mod };
};
Object.defineProperty(exports, "__esModule", { value: true });
const express_1 = __importDefault(require("express"));
const auth_1 = __importDefault(require("../../src/controllers/admin/auth"));
const branch_controller_1 = __importDefault(require("../../src/controllers/admin/operations/branch-controller"));
const router = express_1.default.Router();
router.post('/login', auth_1.default.login);
router.get('/check-visitor-branch', branch_controller_1.default.findAllBranchVisitors);
router.get('/all-branches', branch_controller_1.default.findAll);
router.use((err, req, res, next) => {
    console.error(err.stack);
    res.status(500).send('Something broke!');
});
exports.default = router;
