"use strict";
var __importDefault = (this && this.__importDefault) || function (mod) {
    return (mod && mod.__esModule) ? mod : { "default": mod };
};
Object.defineProperty(exports, "__esModule", { value: true });
const express_1 = __importDefault(require("express"));
const admin_user_permission_roll_middleware_1 = __importDefault(require("../../../middleware/admin/admin-user-permission-roll-middleware"));
const permission_blocks_1 = require("../../../src/constants/permission-blocks");
const referral_source_controller_1 = __importDefault(require("../../../src/controllers/admin/customer-management/referral-source.controller"));
const referralSourceRouter = express_1.default.Router();
const referralSourceController = new referral_source_controller_1.default();
referralSourceRouter.get('/', (0, admin_user_permission_roll_middleware_1.default)({ permissionBlock: permission_blocks_1.permissionBlocks.operations.branch, readOnly: 1 }), referralSourceController.findAll.bind(referralSourceController));
referralSourceRouter.get('/:id', (0, admin_user_permission_roll_middleware_1.default)({ permissionBlock: permission_blocks_1.permissionBlocks.operations.branch, readOnly: 1 }), referralSourceController.findOne.bind(referralSourceController));
referralSourceRouter.post('/', (0, admin_user_permission_roll_middleware_1.default)({ permissionBlock: permission_blocks_1.permissionBlocks.operations.branch, writeOnly: 1 }), referralSourceController.create.bind(referralSourceController));
referralSourceRouter.post('/:id', (0, admin_user_permission_roll_middleware_1.default)({ permissionBlock: permission_blocks_1.permissionBlocks.operations.branch, writeOnly: 1 }), referralSourceController.update.bind(referralSourceController));
referralSourceRouter.delete('/:id', (0, admin_user_permission_roll_middleware_1.default)({ permissionBlock: permission_blocks_1.permissionBlocks.operations.branch }), referralSourceController.destroy.bind(referralSourceController));
referralSourceRouter.use((err, req, res, next) => {
    console.error(err.stack);
    res.status(500).send('Something broke!');
});
exports.default = referralSourceRouter;
