"use strict";
var __importDefault = (this && this.__importDefault) || function (mod) {
    return (mod && mod.__esModule) ? mod : { "default": mod };
};
Object.defineProperty(exports, "__esModule", { value: true });
const express_1 = __importDefault(require("express"));
const admin_user_permission_roll_middleware_1 = __importDefault(require("../../../../middleware/admin/admin-user-permission-roll-middleware"));
const auth_middleware_1 = __importDefault(require("../../../../middleware/admin/auth-middleware"));
const permission_blocks_1 = require("../../../../src/constants/permission-blocks");
const response_status_1 = require("../../../../src/components/response-status");
const item_details_controller_1 = __importDefault(require("../../../../src/controllers/admin/inventory-management/items/item-details-controller"));
const items_other_controller_1 = __importDefault(require("../../../../src/controllers/admin/inventory-management/items/items-other-controller"));
const router = express_1.default.Router();
router.use(auth_middleware_1.default);
router.get('/', response_status_1.logResponseStatus, (0, admin_user_permission_roll_middleware_1.default)({ permissionBlock: permission_blocks_1.permissionBlocks.inventoryManagement.items.items, readOnly: 1 }), item_details_controller_1.default.findAll);
router.get('/:id', (0, admin_user_permission_roll_middleware_1.default)({ permissionBlock: permission_blocks_1.permissionBlocks.inventoryManagement.items.items, writeOnly: 1 }), item_details_controller_1.default.findOne);
router.post('/', (0, admin_user_permission_roll_middleware_1.default)({ permissionBlock: permission_blocks_1.permissionBlocks.inventoryManagement.items.items, readOnly: 1 }), response_status_1.logResponseStatus, item_details_controller_1.default.createItemDetail);
router.post('/:id', (0, admin_user_permission_roll_middleware_1.default)({ permissionBlock: permission_blocks_1.permissionBlocks.inventoryManagement.items.items, writeOnly: 1 }), response_status_1.logResponseStatus, item_details_controller_1.default.ItemDetail);
router.post('/stock-serialnumber-update/item', (0, admin_user_permission_roll_middleware_1.default)({ permissionBlock: permission_blocks_1.permissionBlocks.inventoryManagement.items.items, writeOnly: 1 }), item_details_controller_1.default.updateItemStock);
router.post('/status-change/:id', (0, admin_user_permission_roll_middleware_1.default)({ permissionBlock: permission_blocks_1.permissionBlocks.inventoryManagement.items.items, writeOnly: 1 }), item_details_controller_1.default.statusChange);
router.delete('/:id', (0, admin_user_permission_roll_middleware_1.default)({ permissionBlock: permission_blocks_1.permissionBlocks.inventoryManagement.items.items }), item_details_controller_1.default.destroy);
router.get('/item-requests/all', response_status_1.logResponseStatus, (0, admin_user_permission_roll_middleware_1.default)({ permissionBlock: permission_blocks_1.permissionBlocks.inventoryManagement.items.itemRequests, readOnly: 1 }), items_other_controller_1.default.findAllRequestedItems);
router.post('/item-requests/item-request-accept/:id', response_status_1.logResponseStatus, (0, admin_user_permission_roll_middleware_1.default)({ permissionBlock: permission_blocks_1.permissionBlocks.inventoryManagement.items.itemRequests, writeOnly: 1 }), items_other_controller_1.default.itemRequestAccept);
exports.default = router;
