"use strict";
var __importDefault = (this && this.__importDefault) || function (mod) {
    return (mod && mod.__esModule) ? mod : { "default": mod };
};
Object.defineProperty(exports, "__esModule", { value: true });
const express_1 = __importDefault(require("express"));
const admin_user_permission_roll_middleware_1 = __importDefault(require("../../../../middleware/admin/admin-user-permission-roll-middleware"));
const auth_middleware_1 = __importDefault(require("../../../../middleware/admin/auth-middleware"));
const permission_blocks_1 = require("../../../../src/constants/permission-blocks");
const response_status_1 = require("../../../../src/components/response-status");
const items_master_controller_1 = __importDefault(require("../../../../src/controllers/admin/inventory-management/items/items-master-controller"));
const router = express_1.default.Router();
router.use(auth_middleware_1.default);
router.get('/', response_status_1.logResponseStatus, (0, admin_user_permission_roll_middleware_1.default)({ permissionBlock: permission_blocks_1.permissionBlocks.inventoryManagement.items.items, readOnly: 1 }), items_master_controller_1.default.findAll);
router.get('/:id', (0, admin_user_permission_roll_middleware_1.default)({ permissionBlock: permission_blocks_1.permissionBlocks.inventoryManagement.items.items, writeOnly: 1 }), items_master_controller_1.default.findOne);
router.get('/item-master-details/:id', (0, admin_user_permission_roll_middleware_1.default)({ permissionBlock: permission_blocks_1.permissionBlocks.inventoryManagement.items.items, writeOnly: 1 }), items_master_controller_1.default.findOneItemMasterDetails);
router.post('/bom-item-master-quantity-and-price-change/:id', (0, admin_user_permission_roll_middleware_1.default)({ permissionBlock: permission_blocks_1.permissionBlocks.inventoryManagement.items.items, writeOnly: 1 }), items_master_controller_1.default.updateBomItemQuanity);
router.post('/', (0, admin_user_permission_roll_middleware_1.default)({ permissionBlock: permission_blocks_1.permissionBlocks.inventoryManagement.items.items, readOnly: 1 }), response_status_1.logResponseStatus, items_master_controller_1.default.create);
router.post('/:id', (0, admin_user_permission_roll_middleware_1.default)({ permissionBlock: permission_blocks_1.permissionBlocks.inventoryManagement.items.items, writeOnly: 1 }), response_status_1.logResponseStatus, items_master_controller_1.default.update);
router.post('/status-change/:id', (0, admin_user_permission_roll_middleware_1.default)({ permissionBlock: permission_blocks_1.permissionBlocks.inventoryManagement.items.items, writeOnly: 1 }), items_master_controller_1.default.statusChange);
router.delete('/:id', (0, admin_user_permission_roll_middleware_1.default)({ permissionBlock: permission_blocks_1.permissionBlocks.inventoryManagement.items.items }), items_master_controller_1.default.destroy);
exports.default = router;
