"use strict";
var __importDefault = (this && this.__importDefault) || function (mod) {
    return (mod && mod.__esModule) ? mod : { "default": mod };
};
Object.defineProperty(exports, "__esModule", { value: true });
const express_1 = __importDefault(require("express"));
const admin_user_permission_roll_middleware_1 = __importDefault(require("../../../../middleware/admin/admin-user-permission-roll-middleware"));
const auth_middleware_1 = __importDefault(require("../../../../middleware/admin/auth-middleware"));
const permission_blocks_1 = require("../../../../src/constants/permission-blocks");
const response_status_1 = require("../../../../src/components/response-status");
const products_controller_1 = __importDefault(require("../../../../src/controllers/admin/inventory-management/products/products.controller"));
const productsRouter = express_1.default.Router();
const productsController = new products_controller_1.default();
productsRouter.use(auth_middleware_1.default);
productsRouter.get('/', response_status_1.logResponseStatus, (0, admin_user_permission_roll_middleware_1.default)({ permissionBlock: permission_blocks_1.permissionBlocks.inventoryManagement.products.products, readOnly: 1 }), productsController.findAll.bind(productsController));
productsRouter.get('/stock-inventory', response_status_1.logResponseStatus, (0, admin_user_permission_roll_middleware_1.default)({ permissionBlock: permission_blocks_1.permissionBlocks.inventoryManagement.products.stockInventory, readOnly: 1 }), productsController.getStockInventory.bind(productsController));
productsRouter.get('/filter-data', response_status_1.logResponseStatus, (0, admin_user_permission_roll_middleware_1.default)({ permissionBlock: permission_blocks_1.permissionBlocks.inventoryManagement.products.stockInventory, readOnly: 1 }), productsController.getFilterData.bind(productsController));
productsRouter.get('/:id', (0, admin_user_permission_roll_middleware_1.default)({ permissionBlock: permission_blocks_1.permissionBlocks.inventoryManagement.products.products, writeOnly: 1 }), productsController.findOne.bind(productsController));
productsRouter.get('/item-master-details/:id', (0, admin_user_permission_roll_middleware_1.default)({ permissionBlock: permission_blocks_1.permissionBlocks.inventoryManagement.products.products, writeOnly: 1 }), productsController.findOneItemMasterDetails.bind(productsController));
productsRouter.post('/bom-item-master-quantity-and-price-change/:id', (0, admin_user_permission_roll_middleware_1.default)({ permissionBlock: permission_blocks_1.permissionBlocks.inventoryManagement.products.products, writeOnly: 1 }), productsController.updateBomItemQuanity.bind(productsController));
productsRouter.post('/', (0, admin_user_permission_roll_middleware_1.default)({ permissionBlock: permission_blocks_1.permissionBlocks.inventoryManagement.products.products, readOnly: 1 }), response_status_1.logResponseStatus, productsController.create.bind(productsController));
// productsRouter.post('/:id', userPermissionMiddleware({ permissionBlock: permissionBlocks.inventoryManagement.products.products, writeOnly: 1 }), logResponseStatus, productsController.update.bind(productsController));
productsRouter.post('/status-change/:id', (0, admin_user_permission_roll_middleware_1.default)({ permissionBlock: permission_blocks_1.permissionBlocks.inventoryManagement.products.products, writeOnly: 1 }), productsController.statusChange.bind(productsController));
productsRouter.delete('/:id', (0, admin_user_permission_roll_middleware_1.default)({ permissionBlock: permission_blocks_1.permissionBlocks.inventoryManagement.products.products }), productsController.destroy.bind(productsController));
productsRouter.post('/stock-serialnumber-update', (0, admin_user_permission_roll_middleware_1.default)({ permissionBlock: permission_blocks_1.permissionBlocks.inventoryManagement.products.products, writeOnly: 1 }), productsController.updateProductStock.bind(productsController));
exports.default = productsRouter;
