"use strict";
var __importDefault = (this && this.__importDefault) || function (mod) {
    return (mod && mod.__esModule) ? mod : { "default": mod };
};
Object.defineProperty(exports, "__esModule", { value: true });
const express_1 = __importDefault(require("express"));
const response_status_1 = require("../../../src/components/response-status");
const auth_middleware_1 = __importDefault(require("../../../middleware/admin/auth-middleware"));
const admin_user_permission_roll_middleware_1 = __importDefault(require("../../../middleware/admin/admin-user-permission-roll-middleware"));
const permission_blocks_1 = require("../../../src/constants/permission-blocks");
const file_uploads_1 = require("../../../src/utils/file-uploads");
const job_order_controller_1 = __importDefault(require("../../../src/controllers/admin/job-order/job-order-controller"));
const router = express_1.default.Router();
const { upload } = (0, file_uploads_1.configureMulter)('galleryimages', ['galleryImage', 'customerIdGalleryImage']);
router.use(auth_middleware_1.default);
router.get('/', response_status_1.logResponseStatus, (0, admin_user_permission_roll_middleware_1.default)({ permissionBlock: permission_blocks_1.permissionBlocks.jobOrders.jobOrder, readOnly: 1 }), job_order_controller_1.default.findAll);
router.get('/job-order-master-detail-simple/:id', (0, admin_user_permission_roll_middleware_1.default)({ permissionBlock: permission_blocks_1.permissionBlocks.jobOrders.jobOrder, writeOnly: 1 }), job_order_controller_1.default.findOneSimple);
router.post('/assign-task/:id', (0, admin_user_permission_roll_middleware_1.default)({ permissionBlock: permission_blocks_1.permissionBlocks.jobOrders.assignTask, writeOnly: 1 }), job_order_controller_1.default.assignTask);
router.get('/find-job-order-details', (0, admin_user_permission_roll_middleware_1.default)({ permissionBlock: permission_blocks_1.permissionBlocks.jobOrders.jobOrder, writeOnly: 1 }), job_order_controller_1.default.findJobOrderDetails);
router.get('/assign-task-history/:id/:detailid', (0, admin_user_permission_roll_middleware_1.default)({ permissionBlock: permission_blocks_1.permissionBlocks.jobOrders.assignTask, writeOnly: 1 }), job_order_controller_1.default.findJobOrderAssignmentHistory);
router.get('/find-all-job-order-customer-item-transfer-history', (0, admin_user_permission_roll_middleware_1.default)({ permissionBlock: permission_blocks_1.permissionBlocks.jobOrders.customerItemHistory, writeOnly: 1 }), job_order_controller_1.default.findAllJobOrderCustomerItemTransferHistory);
router.post('/service-transfer-driver-assign/:id', (0, admin_user_permission_roll_middleware_1.default)({ permissionBlock: permission_blocks_1.permissionBlocks.jobOrders.customerItemHistory, writeOnly: 1 }), job_order_controller_1.default.serviceTransferDriverAssign);
router.post('/assign-vendors/:detailid', (0, admin_user_permission_roll_middleware_1.default)({ permissionBlock: permission_blocks_1.permissionBlocks.jobOrders.assignVendors, writeOnly: 1 }), job_order_controller_1.default.assignVendors);
router.post('/service-status-change/:detailid', (0, admin_user_permission_roll_middleware_1.default)({ permissionBlock: permission_blocks_1.permissionBlocks.jobOrders.serviceStatusChange, writeOnly: 1 }), job_order_controller_1.default.serviceStatusChange);
router.post('/service-transfer-branch/:detailid', (0, admin_user_permission_roll_middleware_1.default)({ permissionBlock: permission_blocks_1.permissionBlocks.jobOrders.manageSpare, writeOnly: 1 }), job_order_controller_1.default.serviceTransferBranch);
router.post('/manage-spare/:id', (0, admin_user_permission_roll_middleware_1.default)({ permissionBlock: permission_blocks_1.permissionBlocks.jobOrders.manageSpare, writeOnly: 1 }), job_order_controller_1.default.manageSpare);
router.post('/manage-by-product/:id', (0, admin_user_permission_roll_middleware_1.default)({ permissionBlock: permission_blocks_1.permissionBlocks.jobOrders.manageByProduct, writeOnly: 1 }), job_order_controller_1.default.manageByProduct);
router.post('/spare-request-and-transfer/:id', (0, admin_user_permission_roll_middleware_1.default)({ permissionBlock: permission_blocks_1.permissionBlocks.jobOrders.itemRequests, writeOnly: 1 }), job_order_controller_1.default.spareRequestAndTransfer);
router.post('/create-job-order', upload.any(), (0, admin_user_permission_roll_middleware_1.default)({ permissionBlock: permission_blocks_1.permissionBlocks.jobOrders.createJobOrder, readOnly: 1 }), response_status_1.logResponseStatus, job_order_controller_1.default.create);
router.post('/:id', upload.any(), (0, admin_user_permission_roll_middleware_1.default)({ permissionBlock: permission_blocks_1.permissionBlocks.jobOrders.jobOrder, writeOnly: 1 }), response_status_1.logResponseStatus, job_order_controller_1.default.update);
// router.post('/status-change/:id', userPermissionMiddleware({ permissionBlock: permissionBlocks.jobOrders.jobOrder, writeOnly: 1 }), JobOrderController.statusChange);
router.delete('/:id', (0, admin_user_permission_roll_middleware_1.default)({ permissionBlock: permission_blocks_1.permissionBlocks.jobOrders.jobOrder }), job_order_controller_1.default.destroy);
router.get('/find-job-order-datas', response_status_1.logResponseStatus, (0, admin_user_permission_roll_middleware_1.default)({ permissionBlock: permission_blocks_1.permissionBlocks.jobOrders.jobOrder, readOnly: 1 }), job_order_controller_1.default.findJobOrderDatas);
exports.default = router;
