"use strict";
var __importDefault = (this && this.__importDefault) || function (mod) {
    return (mod && mod.__esModule) ? mod : { "default": mod };
};
Object.defineProperty(exports, "__esModule", { value: true });
const express_1 = __importDefault(require("express"));
const response_status_1 = require("../../../src/components/response-status");
const auth_middleware_1 = __importDefault(require("../../../middleware/admin/auth-middleware"));
const admin_user_permission_roll_middleware_1 = __importDefault(require("../../../middleware/admin/admin-user-permission-roll-middleware"));
const permission_blocks_1 = require("../../../src/constants/permission-blocks");
const payment_terms_and_cost_center_controller_1 = __importDefault(require("../../../src/controllers/admin/job-order/payment-terms-and-cost-center-controller"));
const router = express_1.default.Router();
router.use(auth_middleware_1.default);
router.post('/manage-payment-terms', response_status_1.logResponseStatus, (0, admin_user_permission_roll_middleware_1.default)({ permissionBlock: permission_blocks_1.permissionBlocks.jobOrders.paymentTerms, readOnly: 1 }), payment_terms_and_cost_center_controller_1.default.managePaymentTerms);
router.post('/manage-cost-center', response_status_1.logResponseStatus, (0, admin_user_permission_roll_middleware_1.default)({ permissionBlock: permission_blocks_1.permissionBlocks.jobOrders.paymentTerms, readOnly: 1 }), payment_terms_and_cost_center_controller_1.default.manageCostCenter);
exports.default = router;
