"use strict";
var __importDefault = (this && this.__importDefault) || function (mod) {
    return (mod && mod.__esModule) ? mod : { "default": mod };
};
Object.defineProperty(exports, "__esModule", { value: true });
const express_1 = __importDefault(require("express"));
const response_status_1 = require("../../../src/components/response-status");
const auth_middleware_1 = __importDefault(require("../../../middleware/admin/auth-middleware"));
const admin_user_permission_roll_middleware_1 = __importDefault(require("../../../middleware/admin/admin-user-permission-roll-middleware"));
const permission_blocks_1 = require("../../../src/constants/permission-blocks");
const customer_accessories_controller_1 = __importDefault(require("../../../src/controllers/admin/other/customer-accessories.controller"));
const customerAccessoryRouter = express_1.default.Router();
customerAccessoryRouter.use(auth_middleware_1.default);
customerAccessoryRouter.get('/', response_status_1.logResponseStatus, (0, admin_user_permission_roll_middleware_1.default)({ permissionBlock: permission_blocks_1.permissionBlocks.other.conditions, readOnly: 1 }), customer_accessories_controller_1.default.findAll);
customerAccessoryRouter.get('/:id', (0, admin_user_permission_roll_middleware_1.default)({ permissionBlock: permission_blocks_1.permissionBlocks.other.conditions, readOnly: 1 }), customer_accessories_controller_1.default.findOne);
customerAccessoryRouter.post('/', (0, admin_user_permission_roll_middleware_1.default)({ permissionBlock: permission_blocks_1.permissionBlocks.other.conditions, writeOnly: 1 }), customer_accessories_controller_1.default.create);
customerAccessoryRouter.post('/:id', (0, admin_user_permission_roll_middleware_1.default)({ permissionBlock: permission_blocks_1.permissionBlocks.other.conditions, writeOnly: 1 }), customer_accessories_controller_1.default.update);
exports.default = customerAccessoryRouter;
