"use strict";
var __importDefault = (this && this.__importDefault) || function (mod) {
    return (mod && mod.__esModule) ? mod : { "default": mod };
};
Object.defineProperty(exports, "__esModule", { value: true });
const express_1 = __importDefault(require("express"));
const response_status_1 = require("../../../src/components/response-status");
const auth_middleware_1 = __importDefault(require("../../../middleware/admin/auth-middleware"));
const admin_user_permission_roll_middleware_1 = __importDefault(require("../../../middleware/admin/admin-user-permission-roll-middleware"));
const permission_blocks_1 = require("../../../src/constants/permission-blocks");
const customer_other_service_details_controller_1 = __importDefault(require("../../../src/controllers/admin/other/customer-other-service-details.controller"));
const customerOtherServiceDetailRouter = express_1.default.Router();
customerOtherServiceDetailRouter.use(auth_middleware_1.default);
customerOtherServiceDetailRouter.get('/', response_status_1.logResponseStatus, (0, admin_user_permission_roll_middleware_1.default)({ permissionBlock: permission_blocks_1.permissionBlocks.other.customerOtherServiceDetail, readOnly: 1 }), customer_other_service_details_controller_1.default.findAll);
customerOtherServiceDetailRouter.get('/:id', (0, admin_user_permission_roll_middleware_1.default)({ permissionBlock: permission_blocks_1.permissionBlocks.other.customerOtherServiceDetail, readOnly: 1 }), customer_other_service_details_controller_1.default.findOne);
customerOtherServiceDetailRouter.post('/', (0, admin_user_permission_roll_middleware_1.default)({ permissionBlock: permission_blocks_1.permissionBlocks.other.customerOtherServiceDetail, writeOnly: 1 }), customer_other_service_details_controller_1.default.manageCustomerOtherServiceDetail);
exports.default = customerOtherServiceDetailRouter;
