"use strict";
var __importDefault = (this && this.__importDefault) || function (mod) {
    return (mod && mod.__esModule) ? mod : { "default": mod };
};
Object.defineProperty(exports, "__esModule", { value: true });
const express_1 = __importDefault(require("express"));
const response_status_1 = require("../../../src/components/response-status");
const auth_middleware_1 = __importDefault(require("../../../middleware/admin/auth-middleware"));
const admin_user_permission_roll_middleware_1 = __importDefault(require("../../../middleware/admin/admin-user-permission-roll-middleware"));
const permission_blocks_1 = require("../../../src/constants/permission-blocks");
const settings_controller_1 = __importDefault(require("../../../src/controllers/admin/settings/settings.controller"));
const settingsRouter = express_1.default.Router();
settingsRouter.use(auth_middleware_1.default);
settingsRouter.get('/', response_status_1.logResponseStatus, (0, admin_user_permission_roll_middleware_1.default)({ permissionBlock: permission_blocks_1.permissionBlocks.settings, readOnly: 1 }), settings_controller_1.default.findAll);
settingsRouter.get('/:id', (0, admin_user_permission_roll_middleware_1.default)({ permissionBlock: permission_blocks_1.permissionBlocks.settings, readOnly: 1 }), settings_controller_1.default.findOne);
settingsRouter.post('/', (0, admin_user_permission_roll_middleware_1.default)({ permissionBlock: permission_blocks_1.permissionBlocks.settings, writeOnly: 1 }), settings_controller_1.default.manageSetting);
exports.default = settingsRouter;
