"use strict";
var __importDefault = (this && this.__importDefault) || function (mod) {
    return (mod && mod.__esModule) ? mod : { "default": mod };
};
Object.defineProperty(exports, "__esModule", { value: true });
const express_1 = __importDefault(require("express"));
const response_status_1 = require("../../../src/components/response-status");
const file_uploads_1 = require("../../../src/utils/file-uploads");
const admin_user_permission_roll_middleware_1 = __importDefault(require("../../../middleware/admin/admin-user-permission-roll-middleware"));
const permission_blocks_1 = require("../../../src/constants/permission-blocks");
const admin_users_controller_1 = __importDefault(require("../../../src/controllers/admin/staff-management/admin-users-controller"));
const router = express_1.default.Router();
const { upload } = (0, file_uploads_1.configureMulter)('adminuser', ['userImage']);
router.get('/', response_status_1.logResponseStatus, (0, admin_user_permission_roll_middleware_1.default)({ permissionBlock: permission_blocks_1.permissionBlocks.staffManagement.adminUsers, readOnly: 1 }), admin_users_controller_1.default.findAll);
router.get('/:id', response_status_1.logResponseStatus, (0, admin_user_permission_roll_middleware_1.default)({ permissionBlock: permission_blocks_1.permissionBlocks.staffManagement.adminUsers, readOnly: 1 }), admin_users_controller_1.default.findOne);
router.post('/', upload.single('userImage'), (0, admin_user_permission_roll_middleware_1.default)({ permissionBlock: permission_blocks_1.permissionBlocks.staffManagement.adminUsers, writeOnly: 1 }), response_status_1.logResponseStatus, admin_users_controller_1.default.create);
router.post('/:id', upload.single('userImage'), (0, admin_user_permission_roll_middleware_1.default)({ permissionBlock: permission_blocks_1.permissionBlocks.staffManagement.adminUsers, writeOnly: 1 }), response_status_1.logResponseStatus, admin_users_controller_1.default.update);
router.delete('/:id', response_status_1.logResponseStatus, (0, admin_user_permission_roll_middleware_1.default)({ permissionBlock: permission_blocks_1.permissionBlocks.staffManagement.adminUsers }), admin_users_controller_1.default.destroy);
exports.default = router;
