"use strict";
var __importDefault = (this && this.__importDefault) || function (mod) {
    return (mod && mod.__esModule) ? mod : { "default": mod };
};
Object.defineProperty(exports, "__esModule", { value: true });
const express_1 = __importDefault(require("express"));
const conutry_routes_1 = __importDefault(require("./general/conutry-routes"));
const state_routes_1 = __importDefault(require("./general/state-routes"));
const city_routes_1 = __importDefault(require("./general/city-routes"));
const auth_middleware_1 = __importDefault(require("../middleware/admin/auth-middleware"));
const generalRouter = express_1.default.Router();
generalRouter.use(auth_middleware_1.default);
generalRouter.use('/conutry', conutry_routes_1.default);
generalRouter.use('/state', state_routes_1.default);
generalRouter.use('/city', city_routes_1.default);
exports.default = generalRouter;
