"use strict";
var __importDefault = (this && this.__importDefault) || function (mod) {
    return (mod && mod.__esModule) ? mod : { "default": mod };
};
Object.defineProperty(exports, "__esModule", { value: true });
const express_1 = __importDefault(require("express"));
const permission_blocks_1 = require("../../src/constants/permission-blocks");
const admin_user_permission_roll_middleware_1 = __importDefault(require("../../middleware/admin/admin-user-permission-roll-middleware"));
const city_controller_1 = __importDefault(require("../../src/controllers/general/city-controller"));
const router = express_1.default.Router();
router.get('/', city_controller_1.default.findAllCity);
router.get('/:id', (0, admin_user_permission_roll_middleware_1.default)({ permissionBlock: permission_blocks_1.permissionBlocks.general.city, readOnly: 1 }), city_controller_1.default.findOneCity);
router.post('/', (0, admin_user_permission_roll_middleware_1.default)({ permissionBlock: permission_blocks_1.permissionBlocks.general.city, writeOnly: 1 }), city_controller_1.default.createCity);
router.post('/:id', (0, admin_user_permission_roll_middleware_1.default)({ permissionBlock: permission_blocks_1.permissionBlocks.general.city, writeOnly: 1 }), city_controller_1.default.updateCity);
router.delete('/:id', (0, admin_user_permission_roll_middleware_1.default)({ permissionBlock: permission_blocks_1.permissionBlocks.general.city }), city_controller_1.default.destroy);
exports.default = router;
