"use strict";
var __importDefault = (this && this.__importDefault) || function (mod) {
    return (mod && mod.__esModule) ? mod : { "default": mod };
};
Object.defineProperty(exports, "__esModule", { value: true });
const express_1 = __importDefault(require("express"));
const permission_blocks_1 = require("../../src/constants/permission-blocks");
const admin_user_permission_roll_middleware_1 = __importDefault(require("../../middleware/admin/admin-user-permission-roll-middleware"));
const country_controller_1 = __importDefault(require("../../src/controllers/general/country-controller"));
const router = express_1.default.Router();
router.get('/', country_controller_1.default.findAll);
router.get('/:id', (0, admin_user_permission_roll_middleware_1.default)({ permissionBlock: permission_blocks_1.permissionBlocks.general.country, readOnly: 1 }), country_controller_1.default.findOne);
router.post('/', (0, admin_user_permission_roll_middleware_1.default)({ permissionBlock: permission_blocks_1.permissionBlocks.general.country, writeOnly: 1 }), country_controller_1.default.create);
router.post('/:id', (0, admin_user_permission_roll_middleware_1.default)({ permissionBlock: permission_blocks_1.permissionBlocks.general.country, writeOnly: 1 }), country_controller_1.default.update);
router.delete('/:id', (0, admin_user_permission_roll_middleware_1.default)({ permissionBlock: permission_blocks_1.permissionBlocks.general.country }), country_controller_1.default.destroy);
exports.default = router;
