"use strict";
var __importDefault = (this && this.__importDefault) || function (mod) {
    return (mod && mod.__esModule) ? mod : { "default": mod };
};
Object.defineProperty(exports, "__esModule", { value: true });
const express_1 = __importDefault(require("express"));
const permission_blocks_1 = require("../../src/constants/permission-blocks");
const admin_user_permission_roll_middleware_1 = __importDefault(require("../../middleware/admin/admin-user-permission-roll-middleware"));
const state_controller_1 = __importDefault(require("../../src/controllers/general/state-controller"));
const router = express_1.default.Router();
router.get('/', state_controller_1.default.findAllState);
router.get('/:id', (0, admin_user_permission_roll_middleware_1.default)({ permissionBlock: permission_blocks_1.permissionBlocks.general.state, readOnly: 1 }), state_controller_1.default.findOneState);
router.post('/', (0, admin_user_permission_roll_middleware_1.default)({ permissionBlock: permission_blocks_1.permissionBlocks.general.state, writeOnly: 1 }), state_controller_1.default.createState);
router.post('/:id', (0, admin_user_permission_roll_middleware_1.default)({ permissionBlock: permission_blocks_1.permissionBlocks.general.state, writeOnly: 1 }), state_controller_1.default.updateState);
router.delete('/:id', (0, admin_user_permission_roll_middleware_1.default)({ permissionBlock: permission_blocks_1.permissionBlocks.general.state }), state_controller_1.default.destroyState);
exports.default = router;
