"use strict";
var __importDefault = (this && this.__importDefault) || function (mod) {
    return (mod && mod.__esModule) ? mod : { "default": mod };
};
Object.defineProperty(exports, "__esModule", { value: true });
const express_1 = __importDefault(require("express"));
const auth_middleware_1 = __importDefault(require("../middleware/admin/auth-middleware"));
const technicians_routes_1 = __importDefault(require("./technicians/technicians-routes"));
const dashboard_routes_1 = __importDefault(require("./technicians/dashboard-routes"));
const outsourcedRouter = express_1.default.Router();
outsourcedRouter.use(auth_middleware_1.default);
// outsourced
outsourcedRouter.use('/all-technicians', technicians_routes_1.default);
outsourcedRouter.use('/technician-dashboard', dashboard_routes_1.default);
exports.default = outsourcedRouter;
