"use strict";
var __importDefault = (this && this.__importDefault) || function (mod) {
    return (mod && mod.__esModule) ? mod : { "default": mod };
};
Object.defineProperty(exports, "__esModule", { value: true });
const express_1 = __importDefault(require("express"));
const admin_user_permission_roll_middleware_1 = __importDefault(require("../../middleware/admin/admin-user-permission-roll-middleware"));
const permission_blocks_1 = require("../../src/constants/permission-blocks");
const technicians_controller_1 = __importDefault(require("../../src/controllers/technician/technicians-controller"));
const router = express_1.default.Router();
router.get('/', (0, admin_user_permission_roll_middleware_1.default)({ permissionBlock: permission_blocks_1.permissionBlocks.technician.technician, readOnly: 1 }), technicians_controller_1.default.findAll);
router.post('/technician-accept-change/:id', (0, admin_user_permission_roll_middleware_1.default)({ permissionBlock: permission_blocks_1.permissionBlocks.technician.technician, writeOnly: 1 }), technicians_controller_1.default.technicianAcceptChange);
router.use((err, req, res, next) => {
    console.error(err.stack);
    res.status(500).send('Something broke!');
});
exports.default = router;
