"use strict";
var __importDefault = (this && this.__importDefault) || function (mod) {
    return (mod && mod.__esModule) ? mod : { "default": mod };
};
Object.defineProperty(exports, "__esModule", { value: true });
const auth_service_1 = __importDefault(require("../../services/admin/auth-service"));
const base_controller_1 = __importDefault(require("../../../src/controllers/admin/base-controller"));
class AuthController extends base_controller_1.default {
    constructor() {
        super();
        this.login = this.login.bind(this);
    }
    async login(req, res) {
        try {
            const { username, password, visitorId, branchId } = req.body;
            const insertedValues = await auth_service_1.default.login(username, password, visitorId, branchId);
            if (insertedValues) {
                this.sendSuccessResponse(res, {
                    requestedData: insertedValues,
                    message: 'Login successfully!'
                }, 200);
            }
            else {
                return this.sendErrorResponse(res, 201, { message: 'Please try again' });
            }
        }
        catch (error) {
            if (error.message === 'Invalid user name.') {
                return this.sendErrorResponse(res, 401, { message: 'Authentication failed. User not found.' });
            }
            else if (error.message === 'Invalid password.') {
                return this.sendErrorResponse(res, 401, { message: 'Authentication failed. Invalid password.' });
            }
            else if (error.message === 'User permission declined') {
                return this.sendErrorResponse(res, 401, { message: 'User permission declined' });
            }
            else {
                return this.sendErrorResponse(res, 500, { message: error?.message || 'Internal Server Error' });
            }
        }
    }
}
exports.default = new AuthController();
