"use strict";
var __importDefault = (this && this.__importDefault) || function (mod) {
    return (mod && mod.__esModule) ? mod : { "default": mod };
};
Object.defineProperty(exports, "__esModule", { value: true });
const base_controller_1 = __importDefault(require("../base-controller"));
const payment_terms_and_cost_center_schema_1 = require("../../../utils/schemas/admin/job-order/payment-terms-and-cost-center-schema");
const helpers_1 = require("../../../utils/helpers");
const payment_terms_model_1 = __importDefault(require("../../../model/admin/job-order/payment-terms-model"));
const cost_centers_model_1 = __importDefault(require("../../../model/admin/job-order/cost-centers-model"));
const mongoose_1 = __importDefault(require("mongoose"));
const controller = new base_controller_1.default();
class PaymentTermsAndCostCenterController extends base_controller_1.default {
    async managePaymentTerms(req, res) {
        try {
            const validatedData = await payment_terms_and_cost_center_schema_1.paymentTermsSchema.safeParseAsync(req.body);
            if (!validatedData.success) {
                return controller.sendErrorResponse(res, 200, {
                    message: 'Validation error',
                    validation: (0, helpers_1.formatZodError)(validatedData.error.errors)
                });
            }
            const user = res.locals.user;
            const { paymentTermsId, paymentTitle, effectOnTotal, amount } = validatedData.data;
            const existingPaymentTerm = await payment_terms_model_1.default.findOne({ _id: new mongoose_1.default.Types.ObjectId(paymentTermsId) });
            let newPaymentTerm = {};
            if (existingPaymentTerm) {
                newPaymentTerm = await payment_terms_model_1.default.updateOne({ _id: existingPaymentTerm._id }, {
                    $set: {
                        effectOnTotal,
                        amount,
                        updatedBy: user._id,
                        updatedAt: new Date(),
                    },
                }, { runValidators: true });
            }
            else {
                newPaymentTerm = new payment_terms_model_1.default({
                    paymentTitle,
                    slug: (0, helpers_1.slugifyManually)(paymentTitle),
                    effectOnTotal,
                    amount,
                    createdBy: user._id,
                    createdAt: new Date(),
                    updatedAt: new Date(),
                });
                await newPaymentTerm.save();
            }
            return controller.sendSuccessResponse(res, {
                requestedData: newPaymentTerm,
                message: 'Success!'
            }, 200);
        }
        catch (error) {
            return controller.sendErrorResponse(res, 500, { message: error.message || 'Some error occurred while deleting item master' });
        }
    }
    async manageCostCenter(req, res) {
        try {
            const validatedData = await payment_terms_and_cost_center_schema_1.costCenterSchema.safeParseAsync(req.body);
            if (!validatedData.success) {
                return controller.sendErrorResponse(res, 200, {
                    message: 'Validation error',
                    validation: (0, helpers_1.formatZodError)(validatedData.error.errors)
                });
            }
            const user = res.locals.user;
            const { costId, costTitle } = validatedData.data;
            const existingcostCenter = await cost_centers_model_1.default.findOne({ _id: new mongoose_1.default.Types.ObjectId(costId) });
            let newcostCenter = {};
            if (existingcostCenter) {
                newcostCenter = await cost_centers_model_1.default.updateOne({ _id: existingcostCenter._id }, {
                    $set: {
                        costTitle,
                        updatedBy: user._id,
                        updatedAt: new Date(),
                    },
                }, { runValidators: true });
            }
            else {
                newcostCenter = new cost_centers_model_1.default({
                    costTitle,
                    slug: (0, helpers_1.slugifyManually)(costTitle),
                    createdBy: user._id,
                    createdAt: new Date(),
                    updatedAt: new Date(),
                });
                await newcostCenter.save();
            }
            return controller.sendSuccessResponse(res, {
                requestedData: newcostCenter,
                message: 'Success!'
            }, 200);
        }
        catch (error) {
            return controller.sendErrorResponse(res, 500, { message: error.message || 'Some error occurred while deleting item master' });
        }
    }
}
exports.default = new PaymentTermsAndCostCenterController();
