"use strict";
var __importDefault = (this && this.__importDefault) || function (mod) {
    return (mod && mod.__esModule) ? mod : { "default": mod };
};
Object.defineProperty(exports, "__esModule", { value: true });
const lodash_1 = require("lodash");
const helpers_1 = require("../../../utils/helpers");
const task_log_1 = require("../../../constants/admin/task-log");
const base_controller_1 = __importDefault(require("../base-controller"));
const customer_other_service_details_model_1 = __importDefault(require("../../../model/admin/other/customer-other-service-details.model"));
const customer_other_service_details_schema_1 = require("../../../utils/schemas/admin/other/customer-other-service-details.schema");
const mongoose_1 = __importDefault(require("mongoose"));
const controller = new base_controller_1.default();
class CustomerOtherServiceDetailsController extends base_controller_1.default {
    async findAll(req, res) {
        try {
            const customerOtherServiceDetails = await customer_other_service_details_model_1.default.find();
            return controller.sendSuccessResponse(res, {
                requestedData: customerOtherServiceDetails,
                totalCount: (0, lodash_1.size)(customerOtherServiceDetails),
                message: 'Success!'
            }, 200);
        }
        catch (error) {
            return controller.sendErrorResponse(res, 500, { message: error.message || 'Some error occurred while fetching  Customer other service detail' });
        }
    }
    async findOne(req, res) {
        try {
            const customerOtherServiceDetailId = req.params.id;
            if (customerOtherServiceDetailId) {
                const customerOtherServiceDetail = await customer_other_service_details_model_1.default.findById(customerOtherServiceDetailId);
                return controller.sendSuccessResponse(res, {
                    requestedData: customerOtherServiceDetail,
                    message: 'Success'
                });
            }
            else {
                return controller.sendErrorResponse(res, 200, {
                    message: 'Customer other service detail Id not found!',
                });
            }
        }
        catch (error) {
            return controller.sendErrorResponse(res, 500, { message: error.message });
        }
    }
    async manageCustomerOtherServiceDetail(req, res) {
        try {
            const validatedData = await customer_other_service_details_schema_1.customerOtherServiceDetailsSchema.safeParseAsync(req.body);
            if (!validatedData.success) {
                return controller.sendErrorResponse(res, 200, {
                    message: 'Validation error',
                    validation: (0, helpers_1.formatZodError)(validatedData.error.errors),
                });
            }
            const data = validatedData.data;
            if (!data.slug) {
                return controller.sendErrorResponse(res, 200, {
                    message: 'Slug is required for identifying the record.',
                });
            }
            const categoryId = new mongoose_1.default.Types.ObjectId(data.categoryId);
            const itemValue = data.itemValue;
            const item = { key: data.categoryId, value: itemValue };
            if (data.itemValue && data.itemValue.trim()) {
                const existingDoc = await customer_other_service_details_model_1.default.findOne({
                    slug: data.slug,
                    'serviceDetailValues.categoryId': categoryId,
                    'serviceDetailValues.data': data.itemValue,
                }).exec();
                if (existingDoc) {
                    return controller.sendErrorResponse(res, 200, {
                        message: `Item '${data.itemValue}' already exists under category ${data.customerOtherServiceDetailsTitle}.`,
                    });
                }
                let retVal = await customer_other_service_details_model_1.default.findOneAndUpdate({ slug: data.slug, 'serviceDetailValues.categoryId': categoryId, }, { $push: { 'serviceDetailValues.$.data': data.itemValue }, updatedAt: new Date(), }, { new: true, }).exec();
                console.log('retVal', retVal, { slug: data.slug, 'serviceDetailValues.categoryId': categoryId, 'serviceDetailValues.data': { $ne: data.itemValue }, });
                if (!retVal) {
                    retVal = await customer_other_service_details_model_1.default.findOneAndUpdate({ slug: data.slug, 'serviceDetailValues.categoryId': { $ne: categoryId } }, {
                        $push: { serviceDetailValues: { categoryId: categoryId, data: [data.itemValue] } },
                        updatedAt: new Date(),
                    }, { new: true, upsert: true, setDefaultsOnInsert: true }).exec();
                }
                return controller.sendSuccessResponse(res, {
                    requestedData: retVal,
                    message: `Item '${data.itemValue}' added successfully under category ${data.categoryId}.`,
                }, 200, {
                    sourceFromId: retVal?._id,
                    sourceFrom: task_log_1.adminTaskLog.other.customerAccessories,
                    activity: task_log_1.adminTaskLogActivity.update,
                    activityStatus: task_log_1.adminTaskLogStatus.success,
                    activityComment: `Added item '${data.itemValue}' under category ${data.categoryId}`,
                });
            }
            const updateObj = {
                customerOtherServiceDetailsTitle: data.customerOtherServiceDetailsTitle,
                updatedAt: new Date(),
                status: data.status || '1',
            };
            const retVal = await customer_other_service_details_model_1.default.findOneAndUpdate({ slug: data.slug }, updateObj, { new: true, upsert: true, setDefaultsOnInsert: true, runValidators: true }).exec();
            return controller.sendSuccessResponse(res, {
                requestedData: retVal,
                message: `${data.customerOtherServiceDetailsTitle} customerOtherServiceDetail managed successfully!`,
            }, 200, {
                sourceFromId: retVal?._id,
                sourceFrom: task_log_1.adminTaskLog.other.customerAccessories,
                activity: task_log_1.adminTaskLogActivity.update,
                activityStatus: task_log_1.adminTaskLogStatus.success,
                activityComment: `${data.customerOtherServiceDetailsTitle} customerOtherServiceDetail managed successfully!`,
            });
        }
        catch (error) {
            return controller.sendErrorResponse(res, 500, {
                message: error.message || 'Some error occurred while updating Customer other service detail',
            });
        }
    }
}
exports.default = new CustomerOtherServiceDetailsController();
