"use strict";
var __importDefault = (this && this.__importDefault) || function (mod) {
    return (mod && mod.__esModule) ? mod : { "default": mod };
};
Object.defineProperty(exports, "__esModule", { value: true });
const base_controller_1 = __importDefault(require("../base-controller"));
const payment_terms_and_cost_center_schema_1 = require("../../../utils/schemas/admin/job-order/payment-terms-and-cost-center-schema");
const helpers_1 = require("../../../utils/helpers");
const payment_terms_model_1 = __importDefault(require("../../../model/admin/other/payment-terms-model"));
const cost_centers_model_1 = __importDefault(require("../../../model/admin/other/cost-centers-model"));
const mongoose_1 = __importDefault(require("mongoose"));
const payment_terms_and_cost_center_service_1 = __importDefault(require("../../../services/other/payment-terms-and-cost-center-service"));
const controller = new base_controller_1.default();
class PaymentTermsAndCostCenterController extends base_controller_1.default {
    async findAllPaymentTerms(req, res) {
        try {
            const { _id, page_size = 1, limit = 10, sortby = '', sortorder = '', keyword = '' } = req.query;
            let query = { _id: { $exists: true } };
            if (_id) {
                query._id = new mongoose_1.default.Types.ObjectId(_id);
            }
            if (keyword) {
                const keywordRegex = new RegExp(keyword, 'i');
                query = {
                    $or: [
                        { paymentTitle: keywordRegex },
                    ],
                    ...query
                };
            }
            const sort = {};
            if (sortby && sortorder) {
                sort[sortby] = sortorder === 'desc' ? -1 : 1;
            }
            const paymentTerms = await payment_terms_and_cost_center_service_1.default.findAllPaymentTerms({
                page: parseInt(page_size),
                limit: parseInt(limit),
                query,
                sort
            });
            return controller.sendSuccessResponse(res, {
                requestedData: paymentTerms.data,
                totalCount: paymentTerms.totalCount,
                message: 'Success!'
            }, 200);
        }
        catch (error) {
            return controller.sendErrorResponse(res, 500, { message: error.message || 'Some error occurred while fetching payment terms' });
        }
    }
    async findAllCostCenter(req, res) {
        try {
            const { _id, page_size = 1, limit = 10, sortby = '', sortorder = '', keyword = '' } = req.query;
            let query = { _id: { $exists: true } };
            if (_id) {
                query._id = new mongoose_1.default.Types.ObjectId(_id);
            }
            if (keyword) {
                const keywordRegex = new RegExp(keyword, 'i');
                query = {
                    $or: [
                        { paymentTitle: keywordRegex },
                    ],
                    ...query
                };
            }
            const sort = {};
            if (sortby && sortorder) {
                sort[sortby] = sortorder === 'desc' ? -1 : 1;
            }
            const costCenters = await payment_terms_and_cost_center_service_1.default.findAllCostCenter({
                page: parseInt(page_size),
                limit: parseInt(limit),
                query,
                sort
            });
            return controller.sendSuccessResponse(res, {
                requestedData: costCenters.data,
                totalCount: costCenters.totalCount,
                message: 'Success!'
            }, 200);
        }
        catch (error) {
            return controller.sendErrorResponse(res, 500, { message: error.message || 'Some error occurred while fetching cost centers' });
        }
    }
    async managePaymentTerms(req, res) {
        try {
            const validatedData = await payment_terms_and_cost_center_schema_1.paymentTermsSchema.safeParseAsync(req.body);
            if (!validatedData.success) {
                return controller.sendErrorResponse(res, 200, {
                    message: 'Validation error',
                    validation: (0, helpers_1.formatZodError)(validatedData.error.errors)
                });
            }
            const user = res.locals.user;
            const { paymentTermsId, paymentTitle } = validatedData.data;
            const existingPaymentTerm = await payment_terms_model_1.default.findOne({ _id: new mongoose_1.default.Types.ObjectId(paymentTermsId) });
            let newPaymentTerm = {};
            if (existingPaymentTerm) {
                newPaymentTerm = await payment_terms_model_1.default.updateOne({ _id: existingPaymentTerm._id }, {
                    $set: {
                        updatedBy: user._id,
                        updatedAt: new Date(),
                    },
                }, { runValidators: true });
            }
            else {
                newPaymentTerm = new payment_terms_model_1.default({
                    paymentTitle,
                    slug: (0, helpers_1.slugifyManually)(paymentTitle),
                    createdBy: user._id,
                    createdAt: new Date(),
                    updatedAt: new Date(),
                });
                await newPaymentTerm.save();
            }
            return controller.sendSuccessResponse(res, {
                requestedData: newPaymentTerm,
                message: 'Success!'
            }, 200);
        }
        catch (error) {
            return controller.sendErrorResponse(res, 500, { message: error.message || 'Some error occurred while deleting item master' });
        }
    }
    async manageCostCenter(req, res) {
        try {
            const validatedData = await payment_terms_and_cost_center_schema_1.costCenterSchema.safeParseAsync(req.body);
            if (!validatedData.success) {
                return controller.sendErrorResponse(res, 200, {
                    message: 'Validation error',
                    validation: (0, helpers_1.formatZodError)(validatedData.error.errors)
                });
            }
            const user = res.locals.user;
            const { costId, costTitle } = validatedData.data;
            const existingcostCenter = await cost_centers_model_1.default.findOne({ _id: new mongoose_1.default.Types.ObjectId(costId) });
            let newcostCenter = {};
            if (existingcostCenter) {
                newcostCenter = await cost_centers_model_1.default.updateOne({ _id: existingcostCenter._id }, {
                    $set: {
                        costTitle,
                        updatedBy: user._id,
                        updatedAt: new Date(),
                    },
                }, { runValidators: true });
            }
            else {
                newcostCenter = new cost_centers_model_1.default({
                    costTitle,
                    slug: (0, helpers_1.slugifyManually)(costTitle),
                    createdBy: user._id,
                    createdAt: new Date(),
                    updatedAt: new Date(),
                });
                await newcostCenter.save();
            }
            return controller.sendSuccessResponse(res, {
                requestedData: newcostCenter,
                message: 'Success!'
            }, 200);
        }
        catch (error) {
            return controller.sendErrorResponse(res, 500, { message: error.message || 'Some error occurred while deleting item master' });
        }
    }
}
exports.default = new PaymentTermsAndCostCenterController();
