"use strict";
var __importDefault = (this && this.__importDefault) || function (mod) {
    return (mod && mod.__esModule) ? mod : { "default": mod };
};
Object.defineProperty(exports, "__esModule", { value: true });
const helpers_1 = require("../../../../src/utils/helpers");
const base_controller_1 = __importDefault(require("../../../../src/controllers/admin/base-controller"));
const privilages_service_1 = __importDefault(require("../../../services/admin/staff-management/privilages-service"));
const privilage_shema_1 = require("../../../utils/schemas/admin/staff-management/privilage-shema");
const task_log_1 = require("../../../../src/constants/admin/task-log");
const controller = new base_controller_1.default();
class PrivilagesController extends base_controller_1.default {
    async findAll(req, res) {
        try {
            let query = { _id: { $exists: true } };
            const privilages = await privilages_service_1.default.findAll({
                query,
            });
            return controller.sendSuccessResponse(res, {
                requestedData: privilages,
                totalCount: await privilages_service_1.default.getTotalCount(query),
                message: 'Success!'
            }, 200);
        }
        catch (error) {
            return controller.sendErrorResponse(res, 500, { message: error.message || 'Some error occurred while fetching users' });
        }
    }
    async managePrivilage(req, res) {
        try {
            const designationId = req.params.id;
            if (designationId) {
                const validatedData = privilage_shema_1.privilageSchema.safeParse(req.body);
                if (validatedData.success) {
                    const { menuItems, status } = validatedData.data;
                    const privilages = await privilages_service_1.default.findOne(designationId);
                    const user = res.locals.user;
                    let privilageData = {};
                    if (privilages) { // update new privilage based on user type
                        const updatedData = {
                            designationId,
                            menuItems,
                            updatedBy: user._id,
                            updatedAt: new Date()
                        };
                        const newPrivilageData = await privilages_service_1.default.update(privilages._id, updatedData);
                        privilageData = {
                            requestedData: newPrivilageData,
                            message: 'Privilage updated successfully!'
                        };
                    }
                    else { // insert new privilage based on user type
                        const insertData = {
                            designationId,
                            menuItems,
                            status: status || '1',
                            createdBy: user._id,
                            createdAt: new Date()
                        };
                        const updatedPrivilageData = await privilages_service_1.default.create(insertData);
                        privilageData = {
                            requestedData: updatedPrivilageData,
                            message: 'Privilage created successfully!'
                        };
                    }
                    return controller.sendSuccessResponse(res, privilageData, 200, {
                        sourceFromId: '',
                        sourceFrom: task_log_1.adminTaskLog.staffManagement.privilages,
                        activity: task_log_1.adminTaskLogActivity.managePrivilages,
                        activityStatus: task_log_1.adminTaskLogStatus.success
                    });
                }
                else {
                    return controller.sendErrorResponse(res, 200, {
                        message: 'Validation error',
                        validation: (0, helpers_1.formatZodError)(validatedData.error.errors)
                    });
                }
            }
            else {
                return controller.sendErrorResponse(res, 200, {
                    message: 'Privilage Id not found!',
                });
            }
        }
        catch (error) {
            if (error && error.errors && error.errors.designationId && error.errors.designationId.properties) {
                return controller.sendErrorResponse(res, 200, {
                    message: 'Validation error',
                    validation: {
                        designationId: error.errors.designationId.properties.message
                    }
                });
            }
            else if (error && error.errors && error.errors.menuItems && error.errors.menuItems.properties) {
                return controller.sendErrorResponse(res, 200, {
                    message: 'Validation error',
                    validation: {
                        menuItems: error.errors.menuItems.properties.message
                    }
                });
            }
            return controller.sendErrorResponse(res, 500, {
                message: error.message || 'Some error occurred while creating user'
            });
        }
    }
    async findOne(req, res) {
        try {
            const designationId = req.params.id;
            if (designationId) {
                const privilages = await privilages_service_1.default.findOne(designationId);
                if (privilages) {
                    return controller.sendSuccessResponse(res, {
                        requestedData: privilages,
                        message: 'Success'
                    });
                }
                else {
                    return controller.sendSuccessResponse(res, {
                        requestedData: {},
                        message: 'Privilages not found!',
                    });
                }
            }
            else {
                return controller.sendErrorResponse(res, 200, {
                    message: 'Privilage Id not found!',
                });
            }
        }
        catch (error) {
            return controller.sendErrorResponse(res, 500, { message: error.message });
        }
    }
}
exports.default = new PrivilagesController();
