"use strict";
var __importDefault = (this && this.__importDefault) || function (mod) {
    return (mod && mod.__esModule) ? mod : { "default": mod };
};
Object.defineProperty(exports, "__esModule", { value: true });
const base_controller_1 = __importDefault(require("./base-controller"));
const dashboard_service_1 = __importDefault(require("../../services/technician/dashboard-service"));
const project_utils_1 = require("../../utils/project-utils");
const mongoose_1 = __importDefault(require("mongoose"));
const technician_service_1 = __importDefault(require("../../services/technician/technician-service"));
const controller = new base_controller_1.default();
class TechnicianDashboardController {
    async technicianDashboardData(req, res) {
        try {
            const { branchId = '', page_size = 1, limit = 10, sortby = '', sortorder = '', countryId = '' } = req.query;
            let query = { _id: { $exists: true } };
            const user = await res.locals.user;
            const visitorBranchId = (0, project_utils_1.getVisitorBranchId)(user);
            console.log('visitorBranchId', visitorBranchId);
            if (branchId) {
                query.$or = [
                    { 'branchId': new mongoose_1.default.Types.ObjectId(branchId) },
                    { 'transferBranchId': new mongoose_1.default.Types.ObjectId(branchId) },
                ];
            }
            else if (visitorBranchId) {
                query.$or = [
                    { 'branchId': new mongoose_1.default.Types.ObjectId(visitorBranchId) },
                    { 'transferBranchId': new mongoose_1.default.Types.ObjectId(visitorBranchId) },
                ];
            }
            const today = new Date();
            today.setHours(0, 0, 0, 0);
            let currentDate = new Date();
            currentDate.setHours(0, 59, 59, 59);
            today.setDate(today.getDate() - 7);
            const dashboard = await dashboard_service_1.default.findOvervieBoxData({
                query,
            });
            const sort = {};
            if (sortby && sortorder) {
                sort[sortby] = sortorder === 'desc' ? -1 : 1;
            }
            const assignments = await technician_service_1.default.findAll({
                query,
                page: parseInt(page_size),
                limit: parseInt(limit),
                sort,
            });
            return controller.sendSuccessResponse(res, {
                requestedData: {
                    overViewCount: dashboard,
                },
                message: 'Success!'
            }, 200);
        }
        catch (error) {
            return controller.sendErrorResponse(res, 500, { message: error.message || 'Some error occurred while fetching coupons' });
        }
    }
}
exports.default = new TechnicianDashboardController();
