"use strict";
var __importDefault = (this && this.__importDefault) || function (mod) {
    return (mod && mod.__esModule) ? mod : { "default": mod };
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.postCustomer = void 0;
const api_endpoints_1 = require("../config/api.endpoints");
const connect_api_1 = __importDefault(require("../config/connect-api"));
const postCustomer = async (data, type = 'Customer') => {
    const updateValues = {
        "type": type, //Customer/vendor
        "accountCode": data.customerCode,
        "accountName": data.customerTitle,
        "cellular": "123456",
        "emailAddress": data.customerEmail,
        "phone1": `${data.customerCountryCode}${data.customerPhoneNumber}`,
        "phone2": `${data.customerAlternativeCountryCode}${data.customerAlternativePhoneNumber}`,
        // "fax": "54516",
        "active": "yes",
        // "website": "website@website",
        "objAddress": [
            {
                "addressName": data.address1,
                "country": data?.country?.countryTitle,
                // "state": "",
                // "city": "Dubai",
                // "zipCode": "",
                // "addressType": "S"
            }
        ]
    };
    const retVal = await connect_api_1.default.postAPI({
        apiEndpoint: api_endpoints_1.apiEndpoints.customer,
        ...updateValues
    });
    console.log('retVal', retVal);
};
exports.postCustomer = postCustomer;
