"use strict";
var __importDefault = (this && this.__importDefault) || function (mod) {
    return (mod && mod.__esModule) ? mod : { "default": mod };
};
Object.defineProperty(exports, "__esModule", { value: true });
const server_connect_api_1 = __importDefault(require("./server-connect-api"));
const postAPI = async (postAPIValues) => {
    const { apiEndpoint, ...restParams } = postAPIValues;
    if (restParams.formData) {
        var formData = new FormData();
        for (const newValues in restParams) {
            formData.append(newValues, restParams[newValues]);
        }
        return await server_connect_api_1.default.post(apiEndpoint, formData);
    }
    else {
        return await server_connect_api_1.default.post(apiEndpoint, JSON.stringify(restParams), { headers: { "Content-Type": "application/json; charset=utf-8", Accept: "application/json" } });
    }
};
const fetchAPIData = async (params = {}) => {
    const { apiEndpoint, ...restParams } = params;
    return await server_connect_api_1.default.get(apiEndpoint, { params: restParams });
};
const connectApi = {
    fetchAPIData,
    postAPI
};
exports.default = connectApi;
