"use strict";
var __importDefault = (this && this.__importDefault) || function (mod) {
    return (mod && mod.__esModule) ? mod : { "default": mod };
};
Object.defineProperty(exports, "__esModule", { value: true });
const axios_1 = __importDefault(require("axios"));
const serverConnectAPI = axios_1.default.create({
    baseURL: `${process.env.SAP_API_URI}/`,
    // headers: { "Content-Type": "application/json;charset=UTF-8", Accept: "application/json" },
    headers: { "Content-Type": "multipart/form-data", Accept: "*/*" },
    // headers: { "Content-Type": "application/json;charset=UTF-8", Accept: "application/json" },
});
serverConnectAPI.interceptors.request.use(async function (config) {
    // config.headers["Authorization"] = `Bearer ${authToken}`;
    return config;
}, function (error) {
    return Promise.reject(error);
});
serverConnectAPI.interceptors.response.use(async function (response) {
    if ((response) && (response.status === 200)) {
        if (response.data) {
            if ((response.data.status === false) && (response.data.validation)) {
                throw response.data.validation;
            }
            else if ((response.data.status === false) && (response.data.message !== "")) {
                throw response.data.message;
            }
            else {
                if (response.data) {
                    return response.data;
                }
                else {
                    return response;
                }
            }
        }
    }
    else {
        if (response.status === 201) {
        }
        else if (response.status === 403) {
            alert('You have not permission to this action!');
        }
        else if (response.status === 204) {
            throw "No content found";
        }
    }
}, function (error) {
    if (error && error.response) {
        const { data, status } = error.response;
        if ((data) && (status == '401')) { // validation error
            if (data.errorMsg) {
                return Promise.reject(data.errorMsg);
            }
            else {
                if (data.message) {
                    return Promise.reject(data.message);
                }
                else {
                    return Promise.reject("Validation error (status 401)");
                }
            }
        }
        else if ((status === 500) && data) {
            return Promise.reject(data.message);
        }
        else {
            return Promise.reject(error.message);
        }
    }
    else {
        return Promise.reject(error.message);
    }
    return Promise.reject(error);
});
exports.default = serverConnectAPI;
