"use strict";
var __createBinding = (this && this.__createBinding) || (Object.create ? (function(o, m, k, k2) {
    if (k2 === undefined) k2 = k;
    var desc = Object.getOwnPropertyDescriptor(m, k);
    if (!desc || ("get" in desc ? !m.__esModule : desc.writable || desc.configurable)) {
      desc = { enumerable: true, get: function() { return m[k]; } };
    }
    Object.defineProperty(o, k2, desc);
}) : (function(o, m, k, k2) {
    if (k2 === undefined) k2 = k;
    o[k2] = m[k];
}));
var __setModuleDefault = (this && this.__setModuleDefault) || (Object.create ? (function(o, v) {
    Object.defineProperty(o, "default", { enumerable: true, value: v });
}) : function(o, v) {
    o["default"] = v;
});
var __importStar = (this && this.__importStar) || function (mod) {
    if (mod && mod.__esModule) return mod;
    var result = {};
    if (mod != null) for (var k in mod) if (k !== "default" && Object.prototype.hasOwnProperty.call(mod, k)) __createBinding(result, mod, k);
    __setModuleDefault(result, mod);
    return result;
};
var __importDefault = (this && this.__importDefault) || function (mod) {
    return (mod && mod.__esModule) ? mod : { "default": mod };
};
Object.defineProperty(exports, "__esModule", { value: true });
const mongoose_1 = __importStar(require("mongoose"));
const collections_1 = require("../../../constants/collections");
const sequence_model_1 = __importDefault(require("../../general/sequence-model"));
const customerSchema = new mongoose_1.Schema({
    branchId: {
        type: mongoose_1.Schema.Types.ObjectId,
        ref: collections_1.collections.operations.branches,
        required: false,
        default: null
    },
    countryId: {
        type: mongoose_1.Schema.Types.ObjectId,
        ref: collections_1.collections.general.countries,
        default: null
    },
    stateId: {
        type: mongoose_1.Schema.Types.ObjectId,
        ref: collections_1.collections.general.states,
        default: null
    },
    cityId: {
        type: mongoose_1.Schema.Types.ObjectId,
        ref: collections_1.collections.general.cities,
        default: null
    },
    customerType: {
        type: String,
        default: ''
    },
    customerTitle: {
        type: String,
        default: ''
    },
    customerTitleType: {
        type: String,
        default: ''
    },
    customerCode: {
        type: String,
        unique: true,
    },
    customerEmail: {
        type: String,
        required: true,
        unique: true,
        validate: {
            validator: async function (value) {
                const count = await this.model(collections_1.collections.customerManagement.customerMaster).countDocuments({ customerEmail: value });
                return count === 0;
            },
            message: 'Email must be unique'
        },
        match: [/\S+@\S+\.\S+/, 'Email format is invalid']
    },
    customerPhoneNumber: {
        type: String,
        required: true,
        unique: true,
        validate: {
            validator: async function (value) {
                const count = await this.model(collections_1.collections.customerManagement.customerMaster).countDocuments({ customerPhoneNumber: value });
                return count === 0;
            },
            message: 'Phone must be unique'
        },
        minlength: [9, 'Phone must be at least 9 characters long'],
        maxlength: [13, 'Phone maximum 13 characters long'],
    },
    customerCountryCode: {
        type: String,
        default: ''
    },
    customerAlternativePhoneNumber: {
        type: String,
        default: ''
    },
    customerAlternativeCountryCode: {
        type: String,
        default: ''
    },
    dob: {
        type: String,
        default: ''
    },
    referralSource: {
        type: String,
        default: ''
    },
    customerPassword: {
        type: String,
        default: ''
    },
    customerImageUrl: {
        type: String,
        default: ''
    },
    address1: {
        type: String,
        default: ''
    },
    address2: {
        type: String,
        default: ''
    },
    status: {
        type: String,
        required: true
    },
    createdBy: {
        type: String,
        required: true
    },
    createdAt: {
        type: Date,
    },
    updatedAt: {
        type: Date,
        default: Date.now
    }
});
customerSchema.pre('save', async function (next) {
    if (this.isNew) {
        try {
            const sequenceDoc = await sequence_model_1.default.findOneAndUpdate({ _id: 'customerCodeSequence' }, { $inc: { sequenceValue: 1 } }, { new: true, upsert: true });
            if (sequenceDoc) {
                this.customerCode = String(sequenceDoc.sequenceValue);
                next();
            }
            else {
                throw new Error('Failed to generate customer code.');
            }
        }
        catch (err) {
            next(err);
        }
    }
    else {
        next();
    }
});
const CustomerModel = mongoose_1.default.model(collections_1.collections.customerManagement.customerMaster, customerSchema);
exports.default = CustomerModel;
