"use strict";
var __createBinding = (this && this.__createBinding) || (Object.create ? (function(o, m, k, k2) {
    if (k2 === undefined) k2 = k;
    var desc = Object.getOwnPropertyDescriptor(m, k);
    if (!desc || ("get" in desc ? !m.__esModule : desc.writable || desc.configurable)) {
      desc = { enumerable: true, get: function() { return m[k]; } };
    }
    Object.defineProperty(o, k2, desc);
}) : (function(o, m, k, k2) {
    if (k2 === undefined) k2 = k;
    o[k2] = m[k];
}));
var __setModuleDefault = (this && this.__setModuleDefault) || (Object.create ? (function(o, v) {
    Object.defineProperty(o, "default", { enumerable: true, value: v });
}) : function(o, v) {
    o["default"] = v;
});
var __importStar = (this && this.__importStar) || function (mod) {
    if (mod && mod.__esModule) return mod;
    var result = {};
    if (mod != null) for (var k in mod) if (k !== "default" && Object.prototype.hasOwnProperty.call(mod, k)) __createBinding(result, mod, k);
    __setModuleDefault(result, mod);
    return result;
};
Object.defineProperty(exports, "__esModule", { value: true });
const mongoose_1 = __importStar(require("mongoose"));
const collections_1 = require("../../../../constants/collections");
const job_order_1 = require("../../../../constants/admin/job-order");
const serialNumberSchema = new mongoose_1.Schema({
    itemMasterId: {
        type: mongoose_1.Schema.Types.ObjectId,
        ref: collections_1.collections.inventoryManagement.items.itemsMaster,
        required: true,
    },
    branchId: {
        type: mongoose_1.Schema.Types.ObjectId,
        ref: collections_1.collections.operations.branches,
        required: true,
    },
    itemId: {
        type: mongoose_1.Schema.Types.ObjectId,
        ref: collections_1.collections.inventoryManagement.items.itemsDetails,
        required: true,
    },
    serialNumberType: {
        type: String,
        enum: [job_order_1.serialNumberTypes.serialNumber, job_order_1.serialNumberTypes.batch],
        required: true,
    },
    serialNumber: {
        type: String,
        required: false,
        min: [5, 'Serial number must be 5 digit number.'],
    },
    batchNumber: {
        type: String,
        required: false,
        min: [5, 'Serial number must be 5 digit number.'],
    },
    stockCount: {
        type: Number,
        default: 1
    },
    stockType: {
        type: String,
        enum: [job_order_1.stockTypes.in, job_order_1.stockTypes.out],
        required: true,
    },
    stockOutCount: {
        type: Number,
        default: 0
    }
}, {
    timestamps: true,
});
const ItemDetailsSerialNumberModel = mongoose_1.default.model(collections_1.collections.inventoryManagement.items.serialNumbers, serialNumberSchema);
exports.default = ItemDetailsSerialNumberModel;
