"use strict";
var __createBinding = (this && this.__createBinding) || (Object.create ? (function(o, m, k, k2) {
    if (k2 === undefined) k2 = k;
    var desc = Object.getOwnPropertyDescriptor(m, k);
    if (!desc || ("get" in desc ? !m.__esModule : desc.writable || desc.configurable)) {
      desc = { enumerable: true, get: function() { return m[k]; } };
    }
    Object.defineProperty(o, k2, desc);
}) : (function(o, m, k, k2) {
    if (k2 === undefined) k2 = k;
    o[k2] = m[k];
}));
var __setModuleDefault = (this && this.__setModuleDefault) || (Object.create ? (function(o, v) {
    Object.defineProperty(o, "default", { enumerable: true, value: v });
}) : function(o, v) {
    o["default"] = v;
});
var __importStar = (this && this.__importStar) || function (mod) {
    if (mod && mod.__esModule) return mod;
    var result = {};
    if (mod != null) for (var k in mod) if (k !== "default" && Object.prototype.hasOwnProperty.call(mod, k)) __createBinding(result, mod, k);
    __setModuleDefault(result, mod);
    return result;
};
Object.defineProperty(exports, "__esModule", { value: true });
const mongoose_1 = __importStar(require("mongoose"));
const collections_1 = require("../../../../constants/collections");
const items_1 = require("../../../../constants/items");
const itemMasterSchema = new mongoose_1.Schema({
    categoryId: {
        type: mongoose_1.Schema.Types.ObjectId,
        required: [true, 'Category ID is required'],
        ref: collections_1.collections.inventoryManagement.categories,
    },
    itemMasterTitle: {
        type: String,
        // required: [true, 'Item title is required'],
        unique: true,
        validate: {
            validator: async function (value) {
                const count = await this.model(collections_1.collections.inventoryManagement.items.itemsMaster).countDocuments({ itemMasterTitle: value });
                return count === 0;
            },
            message: 'Item master title must be unique',
        },
    },
    slug: {
        type: String,
        required: true,
        unique: true,
        validate: {
            validator: async function (value) {
                const count = await this.model(collections_1.collections.inventoryManagement.items.itemsMaster).countDocuments({ slug: value });
                return count === 0;
            },
            message: 'Slug must be unique',
        },
    },
    itemMasterCode: {
        type: String,
        required: true,
        unique: true,
        validate: {
            validator: async function (value) {
                const count = await this.model(collections_1.collections.inventoryManagement.items.itemsMaster).countDocuments({ itemMasterCode: value });
                return count === 0;
            },
            message: 'Item code must be unique',
        },
    },
    itemType: {
        type: String,
        enum: [items_1.itemTypes.normal, items_1.itemTypes.bom],
        required: [true, 'Item type is required'],
        default: items_1.itemTypes.normal
    },
    itemMasterPrice: {
        type: Number,
        default: 0
    },
    bomMasterQuantity: {
        type: Number,
        default: 0
    },
    bomMasterOldQuantity: {
        type: Number,
        default: 0
    },
    itemMasterDescription: {
        type: String,
        default: '',
    },
    itemMasterImageUrl: {
        type: String,
        default: '',
    },
    status: {
        type: String,
        required: true,
        enum: ['1', '2', '3'],
        default: '1',
    },
    createdBy: {
        type: String,
        required: true,
    },
    createdAt: {
        type: Date,
        default: Date.now,
    },
    updatedBy: {
        type: String,
    },
    updatedAt: {
        type: Date,
        default: Date.now,
    },
});
const ItemsMasterModel = mongoose_1.default.model(collections_1.collections.inventoryManagement.items.itemsMaster, itemMasterSchema);
exports.default = ItemsMasterModel;
