"use strict";
var __createBinding = (this && this.__createBinding) || (Object.create ? (function(o, m, k, k2) {
    if (k2 === undefined) k2 = k;
    var desc = Object.getOwnPropertyDescriptor(m, k);
    if (!desc || ("get" in desc ? !m.__esModule : desc.writable || desc.configurable)) {
      desc = { enumerable: true, get: function() { return m[k]; } };
    }
    Object.defineProperty(o, k2, desc);
}) : (function(o, m, k, k2) {
    if (k2 === undefined) k2 = k;
    o[k2] = m[k];
}));
var __setModuleDefault = (this && this.__setModuleDefault) || (Object.create ? (function(o, v) {
    Object.defineProperty(o, "default", { enumerable: true, value: v });
}) : function(o, v) {
    o["default"] = v;
});
var __importStar = (this && this.__importStar) || function (mod) {
    if (mod && mod.__esModule) return mod;
    var result = {};
    if (mod != null) for (var k in mod) if (k !== "default" && Object.prototype.hasOwnProperty.call(mod, k)) __createBinding(result, mod, k);
    __setModuleDefault(result, mod);
    return result;
};
Object.defineProperty(exports, "__esModule", { value: true });
const mongoose_1 = __importStar(require("mongoose"));
const collections_1 = require("../../../../constants/collections");
const items_1 = require("../../../../constants/items");
const itemAttributesSchema = new mongoose_1.Schema({
    attributeId: {
        type: mongoose_1.Schema.Types.ObjectId,
        ref: `${collections_1.collections.inventoryManagement.attributeMaster}`,
        required: true
    },
    attributeDetailId: {
        type: mongoose_1.Schema.Types.ObjectId,
        ref: `${collections_1.collections.inventoryManagement.attributeDetail}`,
        required: true
    },
    attributeName: {
        type: String,
        required: [true, 'Attribute name is required']
    },
    itemValue: {
        type: String,
        required: [true, 'Item value is required']
    },
});
const productSchema = new mongoose_1.Schema({
    categoryId: {
        type: mongoose_1.Schema.Types.ObjectId,
        required: [true, 'Category ID is required'],
        ref: collections_1.collections.inventoryManagement.categories,
    },
    warrantyId: {
        type: mongoose_1.Schema.Types.ObjectId,
        default: null,
        ref: collections_1.collections.inventoryManagement.warranty,
    },
    itemTitle: {
        type: String,
        required: [true, 'Item title is required'],
        unique: true,
        validate: {
            validator: async function (value) {
                const count = await this.model(collections_1.collections.inventoryManagement.products.products).countDocuments({ itemTitle: value });
                return count === 0;
            },
            message: 'Item master title must be unique',
        },
    },
    slug: {
        type: String,
        required: true,
        unique: true,
        validate: {
            validator: async function (value) {
                const count = await this.model(collections_1.collections.inventoryManagement.products.products).countDocuments({ slug: value });
                return count === 0;
            },
            message: 'Slug must be unique',
        },
    },
    itemCode: {
        type: String,
        required: true,
        unique: true,
        validate: {
            validator: async function (value) {
                const count = await this.model(collections_1.collections.inventoryManagement.products.products).countDocuments({ itemCode: value });
                return count === 0;
            },
            message: 'Item code must be unique',
        },
    },
    itemType: {
        type: String,
        enum: [items_1.itemTypes.normal, items_1.itemTypes.bom],
        required: [true, 'Item type is required'],
        default: items_1.itemTypes.normal
    },
    itemPrice: {
        type: Number,
        default: 0
    },
    itemQuantity: {
        type: Number,
        default: 0
    },
    barCode: {
        type: String,
        default: ''
    },
    hsnCode: {
        type: String,
        default: ''
    },
    unit: {
        type: String,
        default: ''
    },
    measurements: {
        weight: { type: String, default: '' },
        height: { type: String, default: '' },
        length: { type: String, default: '' },
        width: { type: String, default: '' },
    },
    itemDescription: {
        type: String,
        default: '',
    },
    itemImageUrl: {
        type: String,
        default: '',
    },
    status: {
        type: String,
        required: true,
        enum: ['1', '2', '3'],
        default: '1',
    },
    itemAttributes: {
        type: [itemAttributesSchema],
        default: [],
    },
    createdBy: {
        type: String,
        required: true,
    },
    updatedBy: {
        type: String,
    },
}, { timestamps: true });
const ProductsModel = mongoose_1.default.model(collections_1.collections.inventoryManagement.products.products, productSchema);
exports.default = ProductsModel;
