"use strict";
var __createBinding = (this && this.__createBinding) || (Object.create ? (function(o, m, k, k2) {
    if (k2 === undefined) k2 = k;
    var desc = Object.getOwnPropertyDescriptor(m, k);
    if (!desc || ("get" in desc ? !m.__esModule : desc.writable || desc.configurable)) {
      desc = { enumerable: true, get: function() { return m[k]; } };
    }
    Object.defineProperty(o, k2, desc);
}) : (function(o, m, k, k2) {
    if (k2 === undefined) k2 = k;
    o[k2] = m[k];
}));
var __setModuleDefault = (this && this.__setModuleDefault) || (Object.create ? (function(o, v) {
    Object.defineProperty(o, "default", { enumerable: true, value: v });
}) : function(o, v) {
    o["default"] = v;
});
var __importStar = (this && this.__importStar) || function (mod) {
    if (mod && mod.__esModule) return mod;
    var result = {};
    if (mod != null) for (var k in mod) if (k !== "default" && Object.prototype.hasOwnProperty.call(mod, k)) __createBinding(result, mod, k);
    __setModuleDefault(result, mod);
    return result;
};
var __importDefault = (this && this.__importDefault) || function (mod) {
    return (mod && mod.__esModule) ? mod : { "default": mod };
};
Object.defineProperty(exports, "__esModule", { value: true });
const mongoose_1 = __importStar(require("mongoose"));
const collections_1 = require("../../../constants/collections");
const job_order_1 = require("../../../constants/admin/job-order");
const sequence_model_1 = __importDefault(require("../../general/sequence-model"));
const jobOrderAssignmentHistorySchema = new mongoose_1.Schema({
    taskId: {
        type: Number,
        unique: true,
        required: false,
    },
    jobMasterId: {
        type: mongoose_1.Schema.Types.ObjectId,
        ref: collections_1.collections.jobOrder.jobOrderMasters,
        required: [true, 'Item Master ID is required'],
    },
    jobOrderDetailId: {
        type: mongoose_1.Schema.Types.ObjectId,
        ref: collections_1.collections.jobOrder.jobOrderDetails,
        required: [true, 'Item Master ID is required'],
    },
    technicianId: {
        type: mongoose_1.Schema.Types.ObjectId,
        ref: collections_1.collections.staffManagement.adminUsers,
        required: true
    },
    reassignedFromId: {
        type: mongoose_1.Schema.Types.ObjectId,
        ref: collections_1.collections.staffManagement.adminUsers,
        required: false,
        default: null
    },
    branchId: {
        type: mongoose_1.Schema.Types.ObjectId,
        ref: collections_1.collections.operations.branches,
        required: false,
        default: null
    },
    assignedAt: {
        type: Date,
        required: true,
        default: Date.now
    },
    taskTitle: {
        type: String,
        default: '',
        required: false
    },
    reason: {
        type: String,
        default: '',
        required: false
    },
    description: {
        type: String,
        default: '',
    },
    reassigned: {
        type: Boolean,
        default: false
    },
    priority: {
        type: String,
        enum: [job_order_1.priorities.low, job_order_1.priorities.medium, job_order_1.priorities.high, job_order_1.priorities.veryHigh],
        default: job_order_1.priorities.medium,
    },
    startDate: {
        type: Date,
        default: null,
        required: false
    },
    endDate: {
        type: Date,
        default: null,
        required: false
    },
    taskStartTime: {
        type: mongoose_1.Schema.Types.Mixed,
        default: null,
        required: false
    },
    taskEndTime: {
        type: mongoose_1.Schema.Types.Mixed,
        default: null,
        required: false
    },
    technicianStatus: {
        type: String,
        enum: job_order_1.technicianStatusList,
        required: [true, 'Technician status is required'],
        default: job_order_1.technicianStatusListJson.pending
    },
    technicianStatusAt: {
        type: Date,
        default: Date.now
    },
    reassignedFromIdAt: {
        type: Date,
        default: null
    },
    createdBy: {
        type: String,
        required: true
    },
    createdAt: {
        type: Date,
        default: Date.now
    },
    updatedAt: {
        type: Date,
        default: Date.now
    }
});
jobOrderAssignmentHistorySchema.pre('save', async function (next) {
    if (this.isNew) {
        try {
            const sequenceDoc = await sequence_model_1.default.findOneAndUpdate({ _id: 'taskSequence' }, { $inc: { sequenceValue: 1 } }, { new: true, upsert: true });
            if (sequenceDoc) {
                this.taskId = sequenceDoc.sequenceValue;
                next();
            }
            else {
                throw new Error('Failed to generate job detail number.');
            }
        }
        catch (err) {
            next(err);
        }
    }
    else {
        next();
    }
});
const JobOrderAssignmentHistoryModel = mongoose_1.default.model(collections_1.collections.jobOrder.jobOrderAssignmentHistories, jobOrderAssignmentHistorySchema);
exports.default = JobOrderAssignmentHistoryModel;
