"use strict";
var __createBinding = (this && this.__createBinding) || (Object.create ? (function(o, m, k, k2) {
    if (k2 === undefined) k2 = k;
    var desc = Object.getOwnPropertyDescriptor(m, k);
    if (!desc || ("get" in desc ? !m.__esModule : desc.writable || desc.configurable)) {
      desc = { enumerable: true, get: function() { return m[k]; } };
    }
    Object.defineProperty(o, k2, desc);
}) : (function(o, m, k, k2) {
    if (k2 === undefined) k2 = k;
    o[k2] = m[k];
}));
var __setModuleDefault = (this && this.__setModuleDefault) || (Object.create ? (function(o, v) {
    Object.defineProperty(o, "default", { enumerable: true, value: v });
}) : function(o, v) {
    o["default"] = v;
});
var __importStar = (this && this.__importStar) || function (mod) {
    if (mod && mod.__esModule) return mod;
    var result = {};
    if (mod != null) for (var k in mod) if (k !== "default" && Object.prototype.hasOwnProperty.call(mod, k)) __createBinding(result, mod, k);
    __setModuleDefault(result, mod);
    return result;
};
var __importDefault = (this && this.__importDefault) || function (mod) {
    return (mod && mod.__esModule) ? mod : { "default": mod };
};
Object.defineProperty(exports, "__esModule", { value: true });
const mongoose_1 = __importStar(require("mongoose"));
const collections_1 = require("../../../constants/collections");
const job_order_1 = require("../../../constants/admin/job-order");
const sequence_model_1 = __importDefault(require("../../general/sequence-model"));
const jobOrderDetailsSchema = new mongoose_1.Schema({
    jobDetailNumber: {
        type: Number,
        unique: true,
        required: false,
    },
    jobMasterId: {
        type: mongoose_1.Schema.Types.ObjectId,
        ref: collections_1.collections.jobOrder.jobOrderMasters,
        required: [true, 'Item Master ID is required'],
    },
    itemMasterId: {
        type: mongoose_1.Schema.Types.ObjectId,
        ref: collections_1.collections.inventoryManagement.items.itemsMaster,
        required: [true, 'Item Master ID is required'],
    },
    branchId: {
        type: mongoose_1.Schema.Types.ObjectId,
        ref: collections_1.collections.operations.branches,
        required: [true, 'Branch ID is required'],
    },
    assignedToId: {
        type: mongoose_1.Schema.Types.ObjectId,
        ref: collections_1.collections.staffManagement.adminUsers,
        required: false,
        default: null,
    },
    parentCategoryId: {
        type: mongoose_1.Schema.Types.ObjectId,
        ref: collections_1.collections.inventoryManagement.categories,
        required: [true, 'Parent category is required'],
    },
    categoryId: {
        type: mongoose_1.Schema.Types.ObjectId,
        ref: collections_1.collections.inventoryManagement.categories,
        required: [true, 'Category ID is required'],
    },
    complaintId: {
        type: mongoose_1.Schema.Types.ObjectId,
        ref: collections_1.collections.inventoryManagement.complaint,
        required: [true, 'Complaint ID is required'],
    },
    vendorId: {
        type: mongoose_1.Schema.Types.ObjectId,
        ref: collections_1.collections.outsourced.vendors,
        default: null,
        required: false,
    },
    conditionId: {
        type: mongoose_1.Schema.Types.ObjectId,
        ref: collections_1.collections.other.conditions,
        default: null,
        required: false,
    },
    costCenterId: {
        type: mongoose_1.Schema.Types.ObjectId,
        ref: collections_1.collections.other.costCenters,
        default: null,
        required: false,
    },
    paymentTermId: {
        type: mongoose_1.Schema.Types.ObjectId,
        ref: collections_1.collections.other.paymentTerms,
        default: null,
        required: false,
    },
    transferBranchId: {
        type: mongoose_1.Schema.Types.ObjectId,
        ref: collections_1.collections.operations.branches,
        default: null,
        required: false,
    },
    saleEmployeeId: {
        type: mongoose_1.Schema.Types.ObjectId,
        ref: collections_1.collections.staffManagement.adminUsers,
        default: null,
        required: false,
    },
    driverId: {
        type: mongoose_1.Schema.Types.ObjectId,
        ref: collections_1.collections.staffManagement.adminUsers,
        default: null,
        required: false,
    },
    costItems: [{
            costTypeId: {
                type: mongoose_1.Schema.Types.ObjectId,
                default: null
            },
            operationType: {
                type: String,
                default: ''
            },
            costType: {
                type: String,
                default: ''
            },
            costAmount: {
                type: Number,
                required: false,
                default: null
            },
        }],
    additionalFields: {
        type: mongoose_1.Schema.Types.Mixed,
        default: null
    },
    totalQuantity: {
        type: Number,
        required: false,
    },
    subtotalAmount: {
        type: Number,
        required: false,
    },
    balanceAmount: {
        type: Number,
        required: false,
    },
    totalAmount: {
        type: Number,
        required: false,
    },
    customerSignature: {
        type: String,
        default: ''
    },
    serialNumber: {
        type: Number,
        required: false,
        default: null
    },
    customerComments: {
        type: String,
        default: ''
    },
    remarks: {
        type: String,
        default: ''
    },
    priority: {
        type: String,
        enum: [job_order_1.priorities.low, job_order_1.priorities.medium, job_order_1.priorities.high, job_order_1.priorities.veryHigh],
        default: job_order_1.priorities.medium,
    },
    serviceStatus: {
        type: String,
        required: [true, 'Service status are required'],
        enum: job_order_1.serviceStatusList
    },
    serviceStatusAt: {
        type: Date,
        default: null,
        required: false
    },
    serviceinProgressAt: {
        type: Date,
        default: null,
        required: false
    },
    serviceCanceledAt: {
        type: Date,
        required: false
    },
    serviceCompletedAt: {
        type: Date,
        default: null,
        required: false
    },
    serviceReopenAt: {
        type: Date,
        default: null,
        required: false
    },
    serviceClosedAt: {
        type: Date,
        default: null,
        required: false
    },
    reassigned: {
        type: Boolean,
        default: false
    },
    vendorAssignRemarks: {
        type: String,
        default: ''
    },
    vendorNotes: {
        type: String,
        default: ''
    },
    vendorStatus: {
        type: String,
        enum: job_order_1.vendorStatusList,
        required: [true, 'Technician status is required'],
        default: job_order_1.vendorStatusListJson.pending
    },
    vendorStatusAt: {
        type: Date,
        required: false,
        default: null
    },
    technicianStatus: {
        type: String,
        enum: job_order_1.technicianStatusList,
        required: [true, 'Technician status is required'],
        default: job_order_1.technicianStatusListJson.pending
    },
    technicianStatusAt: {
        type: Date,
        default: null
    },
    transferReason: {
        type: String,
        default: ''
    },
    transferBranchStatus: {
        type: String,
        default: ''
    },
    transferBranchStatusAt: {
        type: Date,
        default: null
    },
    driverHistoryStatusAt: {
        type: Date,
        default: null
    },
    transferBranchAt: {
        type: Date,
        default: null
    },
    serviceType: {
        type: String,
        default: ''
    },
    dueDate: {
        type: Date,
        default: null,
        required: false,
    },
    createdBy: {
        type: String,
        required: true
    },
    createdAt: {
        type: Date,
    },
    updatedAt: {
        type: Date,
        default: Date.now
    }
});
jobOrderDetailsSchema.pre('save', async function (next) {
    if (this.isNew) {
        try {
            const sequenceDoc = await sequence_model_1.default.findOneAndUpdate({ _id: 'jobDetailSequence' }, { $inc: { sequenceValue: 1 } }, { new: true, upsert: true });
            if (sequenceDoc) {
                this.jobDetailNumber = sequenceDoc.sequenceValue;
                next();
            }
            else {
                throw new Error('Failed to generate job detail number.');
            }
        }
        catch (err) {
            next(err);
        }
    }
    else {
        next();
    }
});
const JobOrderDetailsModel = mongoose_1.default.model(collections_1.collections.jobOrder.jobOrderDetails, jobOrderDetailsSchema);
exports.default = JobOrderDetailsModel;
