"use strict";
var __createBinding = (this && this.__createBinding) || (Object.create ? (function(o, m, k, k2) {
    if (k2 === undefined) k2 = k;
    var desc = Object.getOwnPropertyDescriptor(m, k);
    if (!desc || ("get" in desc ? !m.__esModule : desc.writable || desc.configurable)) {
      desc = { enumerable: true, get: function() { return m[k]; } };
    }
    Object.defineProperty(o, k2, desc);
}) : (function(o, m, k, k2) {
    if (k2 === undefined) k2 = k;
    o[k2] = m[k];
}));
var __setModuleDefault = (this && this.__setModuleDefault) || (Object.create ? (function(o, v) {
    Object.defineProperty(o, "default", { enumerable: true, value: v });
}) : function(o, v) {
    o["default"] = v;
});
var __importStar = (this && this.__importStar) || function (mod) {
    if (mod && mod.__esModule) return mod;
    var result = {};
    if (mod != null) for (var k in mod) if (k !== "default" && Object.prototype.hasOwnProperty.call(mod, k)) __createBinding(result, mod, k);
    __setModuleDefault(result, mod);
    return result;
};
var __importDefault = (this && this.__importDefault) || function (mod) {
    return (mod && mod.__esModule) ? mod : { "default": mod };
};
Object.defineProperty(exports, "__esModule", { value: true });
const mongoose_1 = __importStar(require("mongoose"));
const collections_1 = require("../../../constants/collections");
const job_order_1 = require("../../../constants/admin/job-order");
const sequence_model_1 = __importDefault(require("../../general/sequence-model"));
const jobOrderMasterSchema = new mongoose_1.Schema({
    createdBranchId: {
        type: mongoose_1.Schema.Types.ObjectId,
        ref: collections_1.collections.operations.branches,
        required: [true, 'Branch ID is required'],
    },
    customerId: {
        type: mongoose_1.Schema.Types.ObjectId,
        ref: collections_1.collections.customerManagement.customerMaster,
        required: [true, 'Customer ID is required'],
    },
    jobId: {
        type: Number,
        unique: true,
        required: false,
    },
    jobTotalQuantity: {
        type: Number,
        required: false,
    },
    jobSubTotalAmount: {
        type: Number,
        required: false,
    },
    jobBalanceAmount: {
        type: Number,
        required: false,
    },
    jobTotalAmount: {
        type: Number,
        required: false,
    },
    costItems: [{
            jobOrderDetailId: {
                type: mongoose_1.Schema.Types.ObjectId,
                default: null
            },
            costTypeId: {
                type: mongoose_1.Schema.Types.ObjectId,
                default: null
            },
            operationType: {
                type: String,
                default: ''
            },
            costType: {
                type: String,
                default: ''
            },
            costAmount: {
                type: Number,
                required: false,
                default: null
            },
        }],
    jobOrderStatus: {
        type: String,
        enum: job_order_1.jobOrderStatusList,
        required: true
    },
    jobOrderStatusAt: {
        type: Date,
        required: false,
    },
    createdBy: {
        type: String,
        required: true
    },
    createdAt: {
        type: Date,
    },
    updatedAt: {
        type: Date,
        default: Date.now
    }
});
jobOrderMasterSchema.pre('save', async function (next) {
    if (this.isNew) {
        try {
            const sequenceDoc = await sequence_model_1.default.findOneAndUpdate({ _id: 'jobOrderSequence' }, { $inc: { sequenceValue: 1 } }, { new: true, upsert: true });
            if (sequenceDoc) {
                this.jobId = sequenceDoc.sequenceValue;
                next();
            }
            else {
                throw new Error('Failed to generate job ID.');
            }
        }
        catch (err) {
            next(err);
        }
    }
    else {
        next();
    }
});
const JobOrderMaster = mongoose_1.default.model(collections_1.collections.jobOrder.jobOrderMasters, jobOrderMasterSchema);
exports.default = JobOrderMaster;
