"use strict";
var __createBinding = (this && this.__createBinding) || (Object.create ? (function(o, m, k, k2) {
    if (k2 === undefined) k2 = k;
    var desc = Object.getOwnPropertyDescriptor(m, k);
    if (!desc || ("get" in desc ? !m.__esModule : desc.writable || desc.configurable)) {
      desc = { enumerable: true, get: function() { return m[k]; } };
    }
    Object.defineProperty(o, k2, desc);
}) : (function(o, m, k, k2) {
    if (k2 === undefined) k2 = k;
    o[k2] = m[k];
}));
var __setModuleDefault = (this && this.__setModuleDefault) || (Object.create ? (function(o, v) {
    Object.defineProperty(o, "default", { enumerable: true, value: v });
}) : function(o, v) {
    o["default"] = v;
});
var __importStar = (this && this.__importStar) || function (mod) {
    if (mod && mod.__esModule) return mod;
    var result = {};
    if (mod != null) for (var k in mod) if (k !== "default" && Object.prototype.hasOwnProperty.call(mod, k)) __createBinding(result, mod, k);
    __setModuleDefault(result, mod);
    return result;
};
Object.defineProperty(exports, "__esModule", { value: true });
const mongoose_1 = __importStar(require("mongoose"));
const collections_1 = require("../../../constants/collections");
const ServiceDetailValuesSchema = new mongoose_1.Schema({
    categoryId: {
        type: mongoose_1.Schema.Types.ObjectId,
        ref: collections_1.collections.inventoryManagement.categories,
        required: true,
    },
    data: {
        type: [String],
        default: [],
    },
});
const CustomerOtherServiceDetailsSchema = new mongoose_1.Schema({
    customerOtherServiceDetailsTitle: {
        type: String,
        required: true,
        trim: true,
        maxlength: 150,
    },
    slug: {
        type: String,
        required: true,
        trim: true,
        lowercase: true,
        unique: true,
    },
    description: {
        type: String,
        default: '',
        trim: true,
        maxlength: 500,
    },
    serviceDetailValues: {
        type: [ServiceDetailValuesSchema],
        required: true,
        default: [],
        validate: {
            validator: function (value) {
                const categoryIds = value.map((v) => v.categoryId.toString());
                return categoryIds.length === new Set(categoryIds).size;
            },
            message: 'Each categoryId in serviceDetailValues must be unique.',
        },
    },
    status: {
        type: String,
        required: true,
        default: '1',
    },
    createdBy: {
        type: String,
        required: true,
        trim: true,
    },
    createdAt: {
        type: Date,
        default: Date.now,
        immutable: true,
    },
    updatedBy: {
        type: String,
        trim: true,
    },
    updatedAt: {
        type: Date,
        default: Date.now,
    },
}, {
    timestamps: true,
    versionKey: false,
});
const CustomerOtherServiceDetailsModel = mongoose_1.default.model(collections_1.collections.other.customerOtherServiceDetails, CustomerOtherServiceDetailsSchema);
exports.default = CustomerOtherServiceDetailsModel;
