"use strict";
var __createBinding = (this && this.__createBinding) || (Object.create ? (function(o, m, k, k2) {
    if (k2 === undefined) k2 = k;
    var desc = Object.getOwnPropertyDescriptor(m, k);
    if (!desc || ("get" in desc ? !m.__esModule : desc.writable || desc.configurable)) {
      desc = { enumerable: true, get: function() { return m[k]; } };
    }
    Object.defineProperty(o, k2, desc);
}) : (function(o, m, k, k2) {
    if (k2 === undefined) k2 = k;
    o[k2] = m[k];
}));
var __setModuleDefault = (this && this.__setModuleDefault) || (Object.create ? (function(o, v) {
    Object.defineProperty(o, "default", { enumerable: true, value: v });
}) : function(o, v) {
    o["default"] = v;
});
var __importStar = (this && this.__importStar) || function (mod) {
    if (mod && mod.__esModule) return mod;
    var result = {};
    if (mod != null) for (var k in mod) if (k !== "default" && Object.prototype.hasOwnProperty.call(mod, k)) __createBinding(result, mod, k);
    __setModuleDefault(result, mod);
    return result;
};
Object.defineProperty(exports, "__esModule", { value: true });
const mongoose_1 = __importStar(require("mongoose"));
const collections_1 = require("../../../constants/collections");
const userSchema = new mongoose_1.Schema({
    designationId: {
        type: mongoose_1.Schema.Types.ObjectId,
        required: true,
        ref: collections_1.collections.staffManagement.designations,
    },
    branchId: {
        type: mongoose_1.Schema.Types.ObjectId,
        required: true,
        ref: collections_1.collections.operations.branches,
    },
    departmentId: {
        type: mongoose_1.Schema.Types.ObjectId,
        required: true,
        ref: collections_1.collections.staffManagement.departments,
    },
    countryId: {
        type: mongoose_1.Schema.Types.ObjectId,
        ref: collections_1.collections.general.countries,
        default: null
    },
    stateId: {
        type: mongoose_1.Schema.Types.ObjectId,
        ref: collections_1.collections.general.states,
        default: null
    },
    cityId: {
        type: mongoose_1.Schema.Types.ObjectId,
        ref: collections_1.collections.general.cities,
        default: null
    },
    userTitle: {
        type: String,
        default: ''
    },
    userCode: {
        type: String,
        required: true,
        unique: true,
        validate: {
            validator: async function (value) {
                const count = await this.model(collections_1.collections.staffManagement.adminUsers).countDocuments({ userCode: value });
                return count === 0;
            },
            message: 'User code be unique'
        },
    },
    userEmail: {
        type: String,
        required: true,
        unique: true,
        validate: {
            validator: async function (value) {
                const count = await this.model(collections_1.collections.staffManagement.adminUsers).countDocuments({ userEmail: value });
                return count === 0;
            },
            message: 'Email must be unique'
        },
        match: [/\S+@\S+\.\S+/, 'Email format is invalid']
    },
    userPhoneNumber: {
        type: String,
        required: true,
        unique: true,
        validate: {
            validator: async function (value) {
                const count = await this.model(collections_1.collections.staffManagement.adminUsers).countDocuments({ userPhoneNumber: value });
                return count === 0;
            },
            message: 'Phone must be unique'
        },
        minlength: [9, 'Phone must be at least 9 characters long'],
        maxlength: [12, 'Phone maximum 12 characters long'],
    },
    userPassword: {
        type: String,
        required: true
    },
    userImageUrl: {
        type: String,
        default: ''
    },
    status: {
        type: String,
        required: true
    },
    createdBy: {
        type: String,
        required: true
    },
    createdAt: {
        type: Date,
    },
    updatedAt: {
        type: Date,
        default: Date.now
    }
});
const AdminUserModel = mongoose_1.default.model(collections_1.collections.staffManagement.adminUsers, userSchema);
exports.default = AdminUserModel;
