"use strict";
var __createBinding = (this && this.__createBinding) || (Object.create ? (function(o, m, k, k2) {
    if (k2 === undefined) k2 = k;
    var desc = Object.getOwnPropertyDescriptor(m, k);
    if (!desc || ("get" in desc ? !m.__esModule : desc.writable || desc.configurable)) {
      desc = { enumerable: true, get: function() { return m[k]; } };
    }
    Object.defineProperty(o, k2, desc);
}) : (function(o, m, k, k2) {
    if (k2 === undefined) k2 = k;
    o[k2] = m[k];
}));
var __setModuleDefault = (this && this.__setModuleDefault) || (Object.create ? (function(o, v) {
    Object.defineProperty(o, "default", { enumerable: true, value: v });
}) : function(o, v) {
    o["default"] = v;
});
var __importStar = (this && this.__importStar) || function (mod) {
    if (mod && mod.__esModule) return mod;
    var result = {};
    if (mod != null) for (var k in mod) if (k !== "default" && Object.prototype.hasOwnProperty.call(mod, k)) __createBinding(result, mod, k);
    __setModuleDefault(result, mod);
    return result;
};
Object.defineProperty(exports, "__esModule", { value: true });
const mongoose_1 = __importStar(require("mongoose"));
const collections_1 = require("../../constants/collections");
const userSchema = new mongoose_1.Schema({
    vendorTitle: {
        type: String,
        required: true,
        unique: true,
        validate: {
            validator: async function (value) {
                const count = await this.model(collections_1.collections.outsourced.vendors).countDocuments({ vendorTitle: value });
                return count === 0;
            },
            message: 'Vendors Title must be unique'
        }
    },
    slug: {
        type: String,
        required: true,
        unique: true,
        validate: {
            validator: async function (value) {
                const count = await this.model(collections_1.collections.outsourced.vendors).countDocuments({ slug: value });
                return count === 0;
            },
            message: 'Slug must be unique'
        }
    },
    vendorCode: {
        type: String,
        required: true,
        unique: true,
        validate: {
            validator: async function (value) {
                const count = await this.model(collections_1.collections.outsourced.vendors).countDocuments({ vendorCode: value });
                return count === 0;
            },
            message: 'Vendors code must be unique'
        }
    },
    contactName: {
        type: String,
        default: ''
    },
    contactEmail: {
        type: String,
        validate: {
            validator: function (email) {
                return /\S+@\S+\.\S+/.test(email);
            },
            message: 'Invalid email format'
        }
    },
    contactPhone: {
        type: String,
        validate: {
            validator: function (phone) {
                return /^[0-9]{10,15}$/.test(phone);
            },
            message: 'Invalid phone number'
        }
    },
    address: {
        type: String,
        default: ''
    },
    city: {
        type: String,
        default: ''
    },
    country: {
        type: String,
        default: ''
    },
    postalCode: {
        type: String,
        default: ''
    },
    vendorType: {
        type: String,
        // enum: ['manufacturer', 'distributor', 'wholesaler', 'retailer'],
        default: ''
    },
    notes: {
        type: String,
        default: ''
    },
    status: {
        type: String,
        required: true,
        default: '1'
    },
    createdBy: {
        type: mongoose_1.default.Schema.Types.ObjectId,
        required: true
    },
    createdAt: {
        type: Date,
        default: Date.now
    },
    updatedAt: {
        type: Date,
        default: Date.now
    }
});
const VendorsModel = mongoose_1.default.model(collections_1.collections.outsourced.vendors, userSchema);
exports.default = VendorsModel;
