"use strict";
var __importDefault = (this && this.__importDefault) || function (mod) {
    return (mod && mod.__esModule) ? mod : { "default": mod };
};
Object.defineProperty(exports, "__esModule", { value: true });
const jsonwebtoken_1 = __importDefault(require("jsonwebtoken"));
const bcrypt_1 = __importDefault(require("bcrypt"));
const admin_user_model_1 = __importDefault(require("../../model/admin/staff-management/admin-user-model"));
const privilages_service_1 = __importDefault(require("./staff-management/privilages-service"));
const designation_model_1 = __importDefault(require("../../model/admin/staff-management/designation-model"));
const branch_vistor_id_model_1 = __importDefault(require("../../model/admin/operations/branch-vistor-id-model"));
const branch_service_1 = __importDefault(require("./operations/branch-service"));
class AdminAuthService {
    async login(username, password, visitorId, branchId) {
        try {
            const user = await admin_user_model_1.default.findOne({ $and: [{ userEmail: username }, { status: '1' }] }).populate('designationId', ['designationName', 'slug']);
            if (!user) {
                throw new Error('Invalid user name or password!');
            }
            if (user.designationId && user.designationId.slug != "super-admin") {
                const designation = await designation_model_1.default.findOne({ $and: [{ slug: user.designationId.slug }, { status: '1' }] });
                if (!designation) {
                    throw new Error('User permission declined');
                }
            }
            if (user) {
                const isPasswordValid = await bcrypt_1.default.compare(password, user.userPassword);
                if (isPasswordValid) {
                    if (visitorId && branchId) {
                        await branch_vistor_id_model_1.default.create({
                            branchId,
                            visitorId,
                            createdBy: user._id
                        });
                    }
                    const [branchDetails] = await branch_service_1.default.findAllBranchVisitors({
                        query: { visitorId },
                    });
                    const token = jsonwebtoken_1.default.sign({
                        userId: user._id,
                        designationId: user.designationId,
                        branchId: user?.branchId,
                        departmentId: user?.departmentId,
                        countryId: user.countryId,
                        stateId: user?.stateId,
                        cityId: user?.cityId,
                        userEmail: user.userEmail,
                        userCode: user?.userCode,
                        phone: user.phone,
                        branchDetails
                    }, `${process.env.TOKEN_SECRET_KEY}`, { expiresIn: '18h' });
                    let insertedValues = {};
                    if (insertedValues) {
                        const privilages = await privilages_service_1.default.findOne(user.designationId);
                        return {
                            userID: user._id,
                            designationId: user.designationId,
                            countryId: user.countryId,
                            userTitle: user.userTitle,
                            userEmail: user.userEmail,
                            phone: user.phone,
                            token,
                            expiresIn: insertedValues.expiresIn,
                            privilages,
                            branchDetails
                        };
                    }
                    else {
                        throw new Error('Something went wrong. please try agaim!');
                    }
                }
                else {
                    throw new Error('Invalid password.');
                }
            }
            else {
                throw new Error('Invalid user name.');
            }
        }
        catch (error) {
            throw error;
        }
    }
}
exports.default = new AdminAuthService();
