"use strict";
var __importDefault = (this && this.__importDefault) || function (mod) {
    return (mod && mod.__esModule) ? mod : { "default": mod };
};
Object.defineProperty(exports, "__esModule", { value: true });
const lodash_1 = require("lodash");
const pagination_1 = require("../../../components/pagination");
const referral_source_model_1 = __importDefault(require("../../../model/admin/customer-management/referral-source.model"));
class ReferralSourceService {
    constructor(referralSourceModel = referral_source_model_1.default) {
        this.referralSourceModel = referralSourceModel;
    }
    async findAll(options = {}) {
        const { query, skip, limit, sort } = (0, pagination_1.pagination)(options.query || {}, options);
        const defaultSort = { createdAt: -1 };
        let finalSort = sort && Object.keys(sort).length > 0 ? sort : defaultSort;
        const pipeline = [];
        if (Object.keys(query).length) {
            pipeline.push({ $match: query });
        }
        const facetPipeline = {
            totalCount: [{ $count: "count" }],
            data: [
                ...((0, lodash_1.size)(finalSort) > 0 ? [{ $sort: finalSort }] : []),
                ...(skip !== undefined ? [{ $skip: skip }] : []),
                ...(limit !== undefined ? [{ $limit: limit }] : [])
            ]
        };
        pipeline.push({ $facet: facetPipeline });
        const result = await this.referralSourceModel.aggregate(pipeline).exec();
        return {
            totalCount: (0, lodash_1.get)(result, '[0].totalCount[0].count', 0),
            data: (0, lodash_1.get)(result, '[0].data', []),
        };
    }
    async create(referralSourceData) {
        return await this.referralSourceModel.create(referralSourceData);
    }
    async findOne(referralSourceId) {
        return await this.referralSourceModel.findById(referralSourceId);
    }
    async update(referralSourceId, referralSourceData) {
        return await this.referralSourceModel.findByIdAndUpdate(referralSourceId, referralSourceData, { new: true, useFindAndModify: false });
    }
    async destroy(referralSourceId) {
        return await this.referralSourceModel.findOneAndDelete({ _id: referralSourceId });
    }
}
exports.default = ReferralSourceService;
