"use strict";
var __importDefault = (this && this.__importDefault) || function (mod) {
    return (mod && mod.__esModule) ? mod : { "default": mod };
};
Object.defineProperty(exports, "__esModule", { value: true });
const lodash_1 = require("lodash");
const job_order_1 = require("../../constants/admin/job-order");
const job_order_details_model_1 = __importDefault(require("../../model/admin/job-order/job-order-details-model"));
class DashboardService {
    async findOvervieBoxData(options = {}) {
        const { query } = options;
        const pipeline = [];
        if (!(0, lodash_1.isEmpty)(query)) {
            pipeline.push({
                $match: query
            });
        }
        pipeline.push({
            $facet: {
                totalJobOrders: [
                    { $count: "totalJobOrders" }
                ],
                statusCounts: [
                    {
                        $group: {
                            _id: "$serviceStatus",
                            count: { $sum: 1 }
                        }
                    },
                    {
                        $project: {
                            _id: 0,
                            status: "$_id",
                            count: 1
                        }
                    }
                ]
            }
        });
        const result = await job_order_details_model_1.default.aggregate(pipeline);
        const totalJobOrdersCount = result.length > 0 && result[0].totalJobOrders.length > 0
            ? result[0].totalJobOrders[0].totalJobOrders
            : 0;
        const counts = Object.keys(job_order_1.serviceStatusListJson).reduce((acc, key) => {
            acc[key] = 0;
            return acc;
        }, {});
        if (result.length > 0 && result[0]?.statusCounts) {
            result[0].statusCounts.forEach((status) => {
                const mappedKey = Object.keys(job_order_1.serviceStatusListJson).find(key => job_order_1.serviceStatusListJson[key] === status.status);
                if (mappedKey && counts[mappedKey] !== undefined) {
                    counts[mappedKey] = status.count;
                }
            });
        }
        return {
            totalJobOrders: totalJobOrdersCount,
            statusCounts: counts
        };
    }
}
exports.default = new DashboardService();
