"use strict";
var __importDefault = (this && this.__importDefault) || function (mod) {
    return (mod && mod.__esModule) ? mod : { "default": mod };
};
Object.defineProperty(exports, "__esModule", { value: true });
const pagination_1 = require("../../../components/pagination");
const complaint_model_1 = __importDefault(require("../../../model/admin/inventory-management/complaint-model"));
const category_config_1 = require("../../../utils/config/admin/inventory-management/category-config");
const complaint_config_1 = require("../../../utils/config/admin/inventory-management/complaint-config");
class ComplaintService {
    async findAll(options = {}) {
        const { query, skip, limit, sort } = (0, pagination_1.pagination)(options.query || {}, options);
        const defaultSort = { createdAt: -1 };
        let finalSort = sort || defaultSort;
        const sortKeys = Object.keys(finalSort);
        if (sortKeys.length === 0) {
            finalSort = defaultSort;
        }
        let pipeline = [
            { $match: query },
            { $sort: finalSort },
            { $skip: skip },
            { $limit: limit },
            category_config_1.categoryLookup,
            ...complaint_config_1.complaintProject,
        ];
        return complaint_model_1.default.aggregate(pipeline).exec();
    }
    async getTotalCount(query = {}) {
        try {
            const totalCount = await complaint_model_1.default.countDocuments(query);
            return totalCount;
        }
        catch (error) {
            throw new Error('Error fetching total count of complaint');
        }
    }
    async create(complaintData) {
        const createdComplaint = await complaint_model_1.default.create(complaintData);
        if (createdComplaint) {
            const pipeline = [
                { $match: { _id: createdComplaint._id } },
                category_config_1.categoryLookup,
                ...complaint_config_1.complaintProject,
            ];
            const [complaintWithBranch] = await complaint_model_1.default.aggregate(pipeline).exec();
            return complaintWithBranch;
        }
        else {
            return null;
        }
    }
    async findOne(complaintId) {
        const pipeline = [
            { $match: { _id: complaintId } },
            category_config_1.categoryLookup,
            ...complaint_config_1.complaintProject,
        ];
        const [complaintWithBranch] = await complaint_model_1.default.aggregate(pipeline).exec();
        return complaintWithBranch;
    }
    async update(complaintId, complaintData) {
        const updatdComplaint = await complaint_model_1.default.findByIdAndUpdate(complaintId, complaintData, { new: true, useFindAndModify: false });
        if (updatdComplaint) {
            const pipeline = [
                { $match: { _id: updatdComplaint._id } },
                category_config_1.categoryLookup,
                ...complaint_config_1.complaintProject,
            ];
            const [complaintWithBranch] = await complaint_model_1.default.aggregate(pipeline).exec();
            return complaintWithBranch;
        }
        else {
            return null;
        }
    }
    async destroy(complaintId) {
        return complaint_model_1.default.findOneAndDelete({ _id: complaintId });
    }
}
exports.default = new ComplaintService();
