"use strict";
var __importDefault = (this && this.__importDefault) || function (mod) {
    return (mod && mod.__esModule) ? mod : { "default": mod };
};
Object.defineProperty(exports, "__esModule", { value: true });
const pagination_1 = require("../../../components/pagination");
const warranty_model_1 = __importDefault(require("../../../model/admin/inventory-management/warranty-model"));
class WarrantyService {
    async findAll(options = {}) {
        const { query, skip, limit, sort } = (0, pagination_1.pagination)(options.query || {}, options);
        let queryBuilder = warranty_model_1.default.find(query)
            .skip(skip)
            .limit(limit)
            .lean();
        if (sort) {
            queryBuilder = queryBuilder.sort(sort);
        }
        return queryBuilder;
    }
    async getTotalCount(query = {}) {
        try {
            const totalCount = await warranty_model_1.default.countDocuments(query);
            return totalCount;
        }
        catch (error) {
            throw new Error('Error fetching total count of warranty');
        }
    }
    async create(warrantyData) {
        return warranty_model_1.default.create(warrantyData);
    }
    async findOne(warrantyId) {
        return warranty_model_1.default.findById(warrantyId);
    }
    async update(warrantyId, warrantyData) {
        return warranty_model_1.default.findByIdAndUpdate(warrantyId, warrantyData, { new: true, useFindAndModify: false });
    }
    async destroy(warrantyId) {
        return warranty_model_1.default.findOneAndDelete({ _id: warrantyId });
    }
}
exports.default = new WarrantyService();
