"use strict";
var __importDefault = (this && this.__importDefault) || function (mod) {
    return (mod && mod.__esModule) ? mod : { "default": mod };
};
Object.defineProperty(exports, "__esModule", { value: true });
const pagination_1 = require("../../../components/pagination");
const warehouse_model_1 = __importDefault(require("../../../model/admin/operations/warehouse-model"));
const branch_config_1 = require("../../../utils/config/admin/operation/branch-config");
const warehouse_config_1 = require("../../../utils/config/admin/operation/warehouse-config");
class WarehouseService {
    async findAll(options = {}) {
        const { query, skip, limit, sort } = (0, pagination_1.pagination)(options.query || {}, options);
        const defaultSort = { createdAt: -1 };
        let finalSort = sort || defaultSort;
        const sortKeys = Object.keys(finalSort);
        if (sortKeys.length === 0) {
            finalSort = defaultSort;
        }
        let pipeline = [
            { $match: query },
            { $sort: finalSort },
            { $skip: skip },
            { $limit: limit },
            (0, branch_config_1.branchLookup)(),
            ...warehouse_config_1.warehouseProject,
        ];
        return warehouse_model_1.default.aggregate(pipeline).exec();
    }
    async getTotalCount(query = {}) {
        try {
            const totalCount = await warehouse_model_1.default.countDocuments(query);
            return totalCount;
        }
        catch (error) {
            throw new Error('Error fetching total count of warehouse');
        }
    }
    async create(warehouseData) {
        const createdWarehouse = await warehouse_model_1.default.create(warehouseData);
        if (createdWarehouse) {
            const pipeline = [
                { $match: { _id: createdWarehouse._id } },
                (0, branch_config_1.branchLookup)(),
                ...warehouse_config_1.warehouseProject,
            ];
            const [warehouseWithBranch] = await warehouse_model_1.default.aggregate(pipeline).exec();
            return warehouseWithBranch;
        }
        else {
            return null;
        }
    }
    async findOne(warehouseId) {
        const pipeline = [
            { $match: { _id: warehouseId } },
            (0, branch_config_1.branchLookup)(),
            ...warehouse_config_1.warehouseProject,
        ];
        const [warehouseWithBranch] = await warehouse_model_1.default.aggregate(pipeline).exec();
        return warehouseWithBranch;
    }
    async update(warehouseId, warehouseData) {
        const updatdWarehouse = await warehouse_model_1.default.findByIdAndUpdate(warehouseId, warehouseData, { new: true, useFindAndModify: false });
        if (updatdWarehouse) {
            const pipeline = [
                { $match: { _id: warehouseId } },
                (0, branch_config_1.branchLookup)(),
                ...warehouse_config_1.warehouseProject,
            ];
            const [warehouseWithBranch] = await warehouse_model_1.default.aggregate(pipeline).exec();
            return warehouseWithBranch;
        }
        else {
            return null;
        }
    }
    async destroy(warehouseId) {
        return warehouse_model_1.default.findOneAndDelete({ _id: warehouseId });
    }
}
exports.default = new WarehouseService();
