"use strict";
var __importDefault = (this && this.__importDefault) || function (mod) {
    return (mod && mod.__esModule) ? mod : { "default": mod };
};
Object.defineProperty(exports, "__esModule", { value: true });
const pagination_1 = require("../../../components/pagination");
const department_model_1 = __importDefault(require("../../../model/admin/staff-management/department-model"));
class DepartmentService {
    async findAll(options = {}) {
        const { query, skip, limit, sort } = (0, pagination_1.pagination)(options.query || {}, options);
        let queryBuilder = department_model_1.default.find(query)
            .skip(skip)
            .limit(limit)
            .lean();
        if (sort) {
            queryBuilder = queryBuilder.sort(sort);
        }
        return queryBuilder;
    }
    async getTotalCount(query = {}) {
        try {
            const totalCount = await department_model_1.default.countDocuments(query);
            return totalCount;
        }
        catch (error) {
            throw new Error('Error fetching total count of department');
        }
    }
    async create(departmentData) {
        return department_model_1.default.create(departmentData);
    }
    async findOne(departmentId) {
        return department_model_1.default.findById(departmentId);
    }
    async update(departmentId, departmentData) {
        return department_model_1.default.findByIdAndUpdate(departmentId, departmentData, { new: true, useFindAndModify: false });
    }
    async destroy(departmentId) {
        return department_model_1.default.findOneAndDelete({ _id: departmentId });
    }
}
exports.default = new DepartmentService();
