"use strict";
var __importDefault = (this && this.__importDefault) || function (mod) {
    return (mod && mod.__esModule) ? mod : { "default": mod };
};
Object.defineProperty(exports, "__esModule", { value: true });
const pagination_1 = require("../../../components/pagination");
const designation_model_1 = __importDefault(require("../../../model/admin/staff-management/designation-model"));
class DesignationService {
    async findAll(options = {}) {
        const { query, skip, limit, sort } = (0, pagination_1.pagination)(options.query || {}, options);
        let queryBuilder = designation_model_1.default.find(query)
            .skip(skip)
            .limit(limit)
            .lean();
        if (sort) {
            queryBuilder = queryBuilder.sort(sort);
        }
        return queryBuilder;
    }
    async getTotalCount(query = {}) {
        try {
            const totalCount = await designation_model_1.default.countDocuments(query);
            return totalCount;
        }
        catch (error) {
            throw new Error('Error fetching total count of designation');
        }
    }
    async create(designationData) {
        return designation_model_1.default.create(designationData);
    }
    async findOne(designationId) {
        return designation_model_1.default.findById(designationId);
    }
    async update(designationId, designationData) {
        return designation_model_1.default.findByIdAndUpdate(designationId, designationData, { new: true, useFindAndModify: false });
    }
    async destroy(designationId) {
        return designation_model_1.default.findOneAndDelete({ _id: designationId });
    }
}
exports.default = new DesignationService();
