"use strict";
var __importDefault = (this && this.__importDefault) || function (mod) {
    return (mod && mod.__esModule) ? mod : { "default": mod };
};
Object.defineProperty(exports, "__esModule", { value: true });
const lodash_1 = require("lodash");
const pagination_1 = require("../../components/pagination");
const additional_cost_values_model_1 = __importDefault(require("../../model/admin/other/additional-cost-values-model"));
class AdditionalCostValuesService {
    async findAll(options = {}) {
        const { query, skip, limit, sort } = (0, pagination_1.pagination)(options.query || {}, options);
        const defaultSort = { createdAt: -1 };
        let finalSort = sort || defaultSort;
        const sortKeys = Object.keys(finalSort);
        if (sortKeys.length === 0) {
            finalSort = defaultSort;
        }
        let pipeline = [
            { $match: query },
            { $sort: finalSort },
        ];
        const facetPipeline = [
            {
                $facet: {
                    totalCount: [
                        { $count: 'total' }
                    ],
                    data: [
                        { $skip: skip },
                        { $limit: limit }
                    ]
                }
            },
            {
                $project: {
                    totalCount: { $ifNull: [{ $arrayElemAt: ['$totalCount.total', 0] }, 0] },
                    data: 1
                }
            }
        ];
        pipeline.push(...facetPipeline);
        const retVal = await additional_cost_values_model_1.default.aggregate(pipeline).exec();
        return {
            data: (0, lodash_1.get)(retVal, '[0].data', []),
            totalCount: (0, lodash_1.get)(retVal, '[0].totalCount', 0)
        };
    }
    async getTotalCount(query = {}) {
        try {
            const totalCount = await additional_cost_values_model_1.default.countDocuments(query);
            return totalCount;
        }
        catch (error) {
            throw new Error('Error fetching total count of additionalCost');
        }
    }
    async create(additionalCostData) {
        const createdAdditionalCost = await additional_cost_values_model_1.default.create(additionalCostData);
        if (createdAdditionalCost) {
            return createdAdditionalCost;
        }
        else {
            return null;
        }
    }
    async findOne(additionalCostId) {
        const pipeline = [
            { $match: { _id: additionalCostId } },
        ];
        const [additionalCostWithBranch] = await additional_cost_values_model_1.default.aggregate(pipeline).exec();
        return additionalCostWithBranch;
    }
    async update(additionalCostId, additionalCostData) {
        const updatdAdditionalCost = await additional_cost_values_model_1.default.findByIdAndUpdate(additionalCostId, additionalCostData, { new: true, useFindAndModify: false });
        if (updatdAdditionalCost) {
            return updatdAdditionalCost;
        }
        else {
            return null;
        }
    }
    async destroy(additionalCostId) {
        return additional_cost_values_model_1.default.findOneAndDelete({ _id: additionalCostId });
    }
}
exports.default = new AdditionalCostValuesService();
