"use strict";
var __importDefault = (this && this.__importDefault) || function (mod) {
    return (mod && mod.__esModule) ? mod : { "default": mod };
};
Object.defineProperty(exports, "__esModule", { value: true });
const lodash_1 = require("lodash");
const pagination_1 = require("../../components/pagination");
const customer_accessories_model_1 = __importDefault(require("../../model/admin/other/customer-accessories.model"));
const category_config_1 = require("../../utils/config/admin/inventory-management/category-config");
const customer_accessories_config_1 = require("../../utils/config/admin/other/customer-accessories-config");
class CustomerAccessoriesService {
    async findAll(options = {}) {
        const { query, skip, limit, sort } = (0, pagination_1.pagination)(options.query || {}, options);
        const defaultSort = { createdAt: -1 };
        let finalSort = sort || defaultSort;
        const sortKeys = Object.keys(finalSort);
        if (sortKeys.length === 0) {
            finalSort = defaultSort;
        }
        let pipeline = [
            { $match: query },
            { $sort: finalSort },
            category_config_1.categoryLookup,
            ...customer_accessories_config_1.customerAccessoriesProject,
        ];
        const facetPipeline = [
            {
                $facet: {
                    totalCount: [
                        { $count: 'total' }
                    ],
                    data: [
                        { $skip: skip },
                        { $limit: limit }
                    ]
                }
            },
            {
                $project: {
                    totalCount: { $ifNull: [{ $arrayElemAt: ['$totalCount.total', 0] }, 0] },
                    data: 1
                }
            }
        ];
        pipeline.push(...facetPipeline);
        const retVal = await customer_accessories_model_1.default.aggregate(pipeline).exec();
        return {
            data: (0, lodash_1.get)(retVal, '[0].data', []),
            totalCount: (0, lodash_1.get)(retVal, '[0].totalCount', 0)
        };
    }
    async create(customerAccessoriesData) {
        const createdCustomerAccessories = await customer_accessories_model_1.default.create(customerAccessoriesData);
        if (createdCustomerAccessories) {
            const pipeline = [
                { $match: { _id: createdCustomerAccessories._id } },
                category_config_1.categoryLookup,
                ...customer_accessories_config_1.customerAccessoriesProject,
            ];
            const [customerAccessoriesWithBranch] = await customer_accessories_model_1.default.aggregate(pipeline).exec();
            return customerAccessoriesWithBranch;
        }
        else {
            return null;
        }
    }
    async findOne(customerAccessoryId) {
        const pipeline = [
            { $match: { _id: customerAccessoryId } },
            category_config_1.categoryLookup,
            ...customer_accessories_config_1.customerAccessoriesProject,
        ];
        const [customerAccessoriesWithBranch] = await customer_accessories_model_1.default.aggregate(pipeline).exec();
        return customerAccessoriesWithBranch;
    }
    async update(customerAccessoryId, customerAccessoriesData) {
        const updatdCustomerAccessories = await customer_accessories_model_1.default.findByIdAndUpdate(customerAccessoryId, customerAccessoriesData, { new: true, useFindAndModify: false });
        if (updatdCustomerAccessories) {
            const pipeline = [
                { $match: { _id: updatdCustomerAccessories._id } },
                category_config_1.categoryLookup,
                ...customer_accessories_config_1.customerAccessoriesProject,
            ];
            const [customerAccessoriesWithBranch] = await customer_accessories_model_1.default.aggregate(pipeline).exec();
            return customerAccessoriesWithBranch;
        }
        else {
            return null;
        }
    }
    async destroy(customerAccessoryId) {
        return customer_accessories_model_1.default.findOneAndDelete({ _id: customerAccessoryId });
    }
}
exports.default = new CustomerAccessoriesService();
