"use strict";
var __importDefault = (this && this.__importDefault) || function (mod) {
    return (mod && mod.__esModule) ? mod : { "default": mod };
};
Object.defineProperty(exports, "__esModule", { value: true });
const pagination_1 = require("../../components/pagination");
const vendors_model_1 = __importDefault(require("../../model/outsourced/vendors-model"));
class VendorsService {
    async findAll(options = {}) {
        const { query, skip, limit, sort } = (0, pagination_1.pagination)(options.query || {}, options);
        const defaultSort = { createdAt: -1 };
        let finalSort = sort || defaultSort;
        const sortKeys = Object.keys(finalSort);
        if (sortKeys.length === 0) {
            finalSort = defaultSort;
        }
        let pipeline = [
            { $match: query },
            { $sort: finalSort },
            { $skip: skip },
            { $limit: limit },
        ];
        return vendors_model_1.default.aggregate(pipeline).exec();
    }
    async getTotalCount(query = {}) {
        try {
            const totalCount = await vendors_model_1.default.countDocuments(query);
            return totalCount;
        }
        catch (error) {
            throw new Error('Error fetching total count of venVendors');
        }
    }
    async create(venVendorsData) {
        const createdVendors = await vendors_model_1.default.create(venVendorsData);
        if (createdVendors) {
            const pipeline = [
                { $match: { _id: createdVendors._id } },
            ];
            const [venVendorsWithBranch] = await vendors_model_1.default.aggregate(pipeline).exec();
            return venVendorsWithBranch;
        }
        else {
            return null;
        }
    }
    async findOne(venVendorsId) {
        const pipeline = [
            { $match: { _id: venVendorsId } },
        ];
        const [venVendorsWithBranch] = await vendors_model_1.default.aggregate(pipeline).exec();
        return venVendorsWithBranch;
    }
    async update(venVendorsId, venVendorsData) {
        const updatdVendors = await vendors_model_1.default.findByIdAndUpdate(venVendorsId, venVendorsData, { new: true, useFindAndModify: false });
        if (updatdVendors) {
            const pipeline = [
                { $match: { _id: venVendorsId } },
            ];
            const [venVendorsWithBranch] = await vendors_model_1.default.aggregate(pipeline).exec();
            return venVendorsWithBranch;
        }
        else {
            return null;
        }
    }
    async destroy(venVendorsId) {
        return vendors_model_1.default.findOneAndDelete({ _id: venVendorsId });
    }
}
exports.default = new VendorsService();
